
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Australian Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Australian Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Australian Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = \sum(Daily Uses \times Australian Flow Rates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower_uses" class="label-box">Shower Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_uses" name="shower_uses" min="0" step="0.1" value="<?php echo isset($_POST['shower_uses']) ? htmlspecialchars($_POST['shower_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_uses" class="label-box">Toilet Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_uses" name="toilet_uses" min="0" step="0.1" value="<?php echo isset($_POST['toilet_uses']) ? htmlspecialchars($_POST['toilet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_uses" class="label-box">Faucet Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_uses" name="faucet_uses" min="0" step="0.1" value="<?php echo isset($_POST['faucet_uses']) ? htmlspecialchars($_POST['faucet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower_uses']) && 
                        isset($_POST['toilet_uses']) &&
                        isset($_POST['faucet_uses'])) {
                        
                        // Get input values
                        $shower_uses = floatval($_POST['shower_uses']);
                        $toilet_uses = floatval($_POST['toilet_uses']);
                        $faucet_uses = floatval($_POST['faucet_uses']);

                        if ($shower_uses >= 0 && $toilet_uses >= 0 && $faucet_uses >= 0) {
                            // Australian standard flow rates (L/use)
                            $shower_rate = 9;      // L per shower use
                            $toilet_rate = 5;      // L per toilet flush
                            $faucet_rate = 6;      // L per faucet use
                            
                            // Calculate total water usage
                            $usage = ($shower_uses * $shower_rate) + 
                                     ($toilet_uses * $toilet_rate) + 
                                     ($faucet_uses * $faucet_rate);
                            $usage = round($usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Australian Water Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Australian Water Calculator?</h3>
                <p>
The Australian Water Calculator estimates daily water usage based on common household activities using standard Australian flow rates. It helps individuals understand their water consumption patterns and identify opportunities for conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Australian water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum(Daily Uses \times Australian Flow Rates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Daily Uses \) — Number of times an activity is performed per day</li>
                        <li>\( Australian Flow Rates \) — Standard water consumption values (L/use)</li>
                        <li>Shower: 9 L per use</li>
                        <li>Toilet: 5 L per flush</li>
                        <li>Faucet: 6 L per use</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water consumption by multiplying the frequency of each water-using activity by its standard flow rate and summing the results.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding water consumption patterns is crucial for water conservation efforts, reducing utility bills, and promoting sustainable water use practices in Australian households.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of times you use showers, toilets, and faucets each day. The calculator will estimate your total daily water consumption based on Australian standard flow rates.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Are these flow rates accurate for all Australian households?</strong><br>
                    A: These are standard values. Actual consumption may vary based on specific appliance efficiency and user habits.
                </p>
                <p>
                    <strong>Q2: What is considered average water usage in Australia?</strong><br>
                    A: The average Australian household uses about 340-400 liters of water per person per day for indoor activities.
                </p>
                <p>
                    <strong>Q3: How can I reduce my water consumption?</strong><br>
                    A: Install water-efficient fixtures, fix leaks promptly, take shorter showers, and only run full loads in washing machines and dishwashers.
                </p>
                <p>
                    <strong>Q4: Does this calculator include outdoor water usage?</strong><br>
                    A: No, this calculator focuses on indoor water usage. Outdoor usage (gardening, car washing) would need to be calculated separately.
                </p>
                <p>
                    <strong>Q5: Are there rebates available for water-efficient appliances in Australia?</strong><br>
                    A: Many Australian states and territories offer rebates and incentives for installing water-efficient appliances and fixtures. Check with your local water authority.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Australian Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
