
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bc Ag Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Bc Ag Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Agricultural Water Demand Equation:
                </p>
<div class="formula-container">
    \[ demand = area \times crop\_coefficient \times evapotranspiration \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">ha</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="crop_coefficient" class="label-box">Crop Coefficient:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="crop_coefficient" name="crop_coefficient" step="0.0001" min="0" value="<?php echo isset($_POST['crop_coefficient']) ? htmlspecialchars($_POST['crop_coefficient']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="evapotranspiration" class="label-box">Evapotranspiration:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="evapotranspiration" name="evapotranspiration" step="0.0001" min="0" value="<?php echo isset($_POST['evapotranspiration']) ? htmlspecialchars($_POST['evapotranspiration']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['crop_coefficient']) &&
                        isset($_POST['evapotranspiration'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $crop_coefficient = floatval($_POST['crop_coefficient']);
                        $evapotranspiration = floatval($_POST['evapotranspiration']);

                        if ($area > 0 && $crop_coefficient > 0 && $evapotranspiration > 0) {
                            // Calculate agricultural water demand
                            $demand = $area * $crop_coefficient * $evapotranspiration;
                            $demand = round($demand, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Agricultural Water Demand:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($demand) ? htmlspecialchars($demand) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Agricultural Water Demand?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Demand Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Agricultural Water Demand?</h3>
                <p>
Agricultural water demand refers to the amount of water required for crop irrigation in British Columbia. It's calculated based on the crop type, area, and local evapotranspiration rates to ensure optimal water management in agricultural practices.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the agricultural water demand equation:
                </p>
                <div class="formula-2-container">
                    \[ demand = area \times crop\_coefficient \times evapotranspiration \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( area \) — Cultivated area in hectares (ha)</li>
                        <li>\( crop\_coefficient \) — Dimensionless factor specific to crop type</li>
                        <li>\( evapotranspiration \) — Water loss through evaporation and transpiration in millimeters (mm)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water requirement by multiplying the cultivated area with the crop-specific coefficient and the local evapotranspiration rate.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Demand Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water demand estimation is crucial for efficient irrigation planning, water resource management, and sustainable agriculture practices in British Columbia's diverse climatic regions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the cultivated area in hectares, the appropriate crop coefficient for your specific crop, and the local evapotranspiration rate. All values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Where can I find crop coefficient values?</strong><br>
                    A: Crop coefficient values are available from agricultural extension services, irrigation guides, or provincial agricultural resources specific to British Columbia.
                </p>
                <p>
                    <strong>Q2: How often should I calculate water demand?</strong><br>
                    A: Water demand should be calculated regularly throughout the growing season as evapotranspiration rates change with weather conditions.
                </p>
                <p>
                    <strong>Q3: What's a typical evapotranspiration rate for BC?</strong><br>
                    A: Evapotranspiration rates vary significantly across British Columbia's diverse regions, from coastal areas to interior valleys. Local agricultural stations provide region-specific data.
                </p>
                <p>
                    <strong>Q4: Does this calculation account for rainfall?</strong><br>
                    A: This calculation provides total water demand. Effective rainfall should be subtracted from this value to determine irrigation requirements.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for all crop types?</strong><br>
                    A: Yes, but accurate results depend on using the correct crop coefficient specific to each crop type and growth stage.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Bc Ag Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
