
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bc Landscape Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Bc Landscape Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = Area \times Irrigation Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="irrigation_rate" class="label-box">Irrigation Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="irrigation_rate" name="irrigation_rate" step="0.0001" min="0" value="<?php echo isset($_POST['irrigation_rate']) ? htmlspecialchars($_POST['irrigation_rate']) : ''; ?>" required>
                                <span class="calc-input">m³/m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['irrigation_rate'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $irrigation_rate = floatval($_POST['irrigation_rate']);

                        if ($area > 0 && $irrigation_rate > 0) {
                            // Calculate water usage
                            $usage = $area * $irrigation_rate;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the BC Landscape Water Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the BC Landscape Water Calculator?</h3>
                <p>
The BC Landscape Water Calculator estimates water usage for landscape irrigation in British Columbia. It calculates the total water volume required based on the area to be irrigated and the specific irrigation rate.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Area \times Irrigation Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Area \) — Landscape area in square meters (m²)</li>
                        <li>\( Irrigation Rate \) — Water application rate in cubic meters per square meter (m³/m²)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation multiplies the total landscape area by the irrigation rate to determine the total water volume needed.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for efficient water management, irrigation planning, and sustainable landscape maintenance in British Columbia's varying climate conditions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter landscape area in square meters and irrigation rate in cubic meters per square meter. Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical irrigation rate for BC landscapes?</strong><br>
                    A: Irrigation rates vary by plant type and soil conditions, but typically range from 0.0005 to 0.0015 m³/m² for most landscape plants in BC.
                </p>
                <p>
                    <strong>Q2: How often should I irrigate my landscape?</strong><br>
                    A: Irrigation frequency depends on weather conditions, soil type, and plant requirements. In BC, most landscapes need irrigation 1-3 times per week during dry periods.
                </p>
                <p>
                    <strong>Q3: Does this calculator account for rainfall?</strong><br>
                    A: No, this calculator provides total water requirement. Actual irrigation needs should be adjusted based on current rainfall and soil moisture levels.
                </p>
                <p>
                    <strong>Q4: Are there water restrictions in BC I should be aware of?</strong><br>
                    A: Yes, many BC municipalities have seasonal watering restrictions, especially during summer months. Check with your local water authority for specific regulations.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for agricultural irrigation?</strong><br>
                    A: While the basic calculation is similar, agricultural irrigation often requires more complex calculations considering crop type, growth stage, and evapotranspiration rates.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Bc Landscape Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>