
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Beersmith Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Beersmith Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    BeerSmith Water Formula:
                </p>
<div class="formula-container">
    \[ Water (l) = Mash Volume (l) + Sparge Volume (l) + Adjustments \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="mash_volume" class="label-box">Mash Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="mash_volume" name="mash_volume" step="0.01" min="0" value="<?php echo isset($_POST['mash_volume']) ? htmlspecialchars($_POST['mash_volume']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="sparge_volume" class="label-box">Sparge Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="sparge_volume" name="sparge_volume" step="0.01" min="0" value="<?php echo isset($_POST['sparge_volume']) ? htmlspecialchars($_POST['sparge_volume']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="adjustments" class="label-box">Adjustments:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="adjustments" name="adjustments" step="0.01" value="<?php echo isset($_POST['adjustments']) ? htmlspecialchars($_POST['adjustments']) : '0'; ?>">
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['mash_volume']) && 
                        isset($_POST['sparge_volume']) &&
                        isset($_POST['adjustments'])) {
                        
                        // Get input values
                        $mash_volume = floatval($_POST['mash_volume']);
                        $sparge_volume = floatval($_POST['sparge_volume']);
                        $adjustments = floatval($_POST['adjustments']);

                        if ($mash_volume >= 0 && $sparge_volume >= 0) {
                            // Calculate total water
                            $total_water = $mash_volume + $sparge_volume + $adjustments;
                            $total_water = round($total_water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Required:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total_water) ? htmlspecialchars($total_water) . " liters" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the BeerSmith Water Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Calculation in Brewing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the BeerSmith Water Calculator?</h3>
                <p>
The BeerSmith Water Calculator helps homebrewers calculate the total water needed for the brewing process, including mash water, sparge water, and any additional adjustments.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the BeerSmith water formula:
                </p>
                <div class="formula-2-container">
                    \[ Water (l) = Mash Volume (l) + Sparge Volume (l) + Adjustments \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Mash Volume \) — Water used in the mashing process (liters)</li>
                        <li>\( Sparge Volume \) — Water used for sparging (liters)</li>
                        <li>\( Adjustments \) — Additional water adjustments (liters)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water needed for a brewing session by summing the water used in different stages of the process.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Calculation in Brewing</h3>
                <p>
                    <strong>Details:</strong> Accurate water calculation is essential for proper mashing, sparging, and achieving the desired wort concentration and volume in the fermenter.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter mash volume and sparge volume in liters. Include any additional water adjustments needed. All values must be valid (non-negative numbers).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is mash volume?</strong><br>
                    A: Mash volume is the amount of water used to mix with crushed grains during the mashing process to convert starches to sugars.
                </p>
                <p>
                    <strong>Q2: What is sparge volume?</strong><br>
                    A: Sparge volume is the hot water rinsed through the grain bed after mashing to extract remaining sugars.
                </p>
                <p>
                    <strong>Q3: What are typical water adjustments?</strong><br>
                    A: Adjustments may include water for topping up the boil, accounting for evaporation loss, or dilution water.
                </p>
                <p>
                    <strong>Q4: How accurate should my measurements be?</strong><br>
                    A: For best results, measure volumes accurately to within 0.5 liters for typical 5-gallon batches.
                </p>
                <p>
                    <strong>Q5: Does this account for water absorption by grains?</strong><br>
                    A: No, this calculator assumes you've already accounted for grain absorption in your mash and sparge volumes.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Beersmith Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
