
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Brewing Water Calculator UK</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Brewing Water Calculator UK</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Calculation Formula:
                </p>
<div class="formula-container">
    \[ Water (l) = Grain (kg) \times Mash\ Ratio (l/kg) + Sparge (l) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="grain" class="label-box">Grain (kg):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="grain" name="grain" step="0.01" min="0" value="<?php echo isset($_POST['grain']) ? htmlspecialchars($_POST['grain']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="mash_ratio" class="label-box">Mash Ratio (l/kg):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="mash_ratio" name="mash_ratio" step="0.01" min="0" value="<?php echo isset($_POST['mash_ratio']) ? htmlspecialchars($_POST['mash_ratio']) : ''; ?>" required>
                                <span class="calc-input">l/kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="sparge" class="label-box">Sparge (l):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="sparge" name="sparge" step="0.01" min="0" value="<?php echo isset($_POST['sparge']) ? htmlspecialchars($_POST['sparge']) : ''; ?>" required>
                                <span class="calc-input">l</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['grain']) && 
                        isset($_POST['mash_ratio']) &&
                        isset($_POST['sparge'])) {
                        
                        // Get input values
                        $grain = floatval($_POST['grain']);
                        $mash_ratio = floatval($_POST['mash_ratio']);
                        $sparge = floatval($_POST['sparge']);

                        if ($grain >= 0 && $mash_ratio >= 0 && $sparge >= 0) {
                            // Calculate total water
                            $water = ($grain * $mash_ratio) + $sparge;
                            $water = round($water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water (l):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water) ? htmlspecialchars($water) . " l" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Brewing Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Calculation in Brewing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Brewing Water Calculation?</h3>
                <p>
The brewing water calculation determines the total water required for the mashing and sparging processes in beer brewing. It ensures proper hydration of grains and efficient extraction of sugars during the brewing process.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the brewing water formula:
                </p>
                <div class="formula-2-container">
                    \[ Water (l) = Grain (kg) \times Mash\ Ratio (l/kg) + Sparge (l) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Grain \) — Weight of grains in kilograms</li>
                        <li>\( Mash\ Ratio \) — Liters of water per kilogram of grain</li>
                        <li>\( Sparge \) — Additional sparge water in liters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the total water needed by multiplying grain weight by the mash ratio and adding the sparge water volume.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Calculation in Brewing</h3>
                <p>
                    <strong>Details:</strong> Accurate water calculation is crucial for achieving proper mash consistency, efficient sugar extraction, and maintaining the desired beer characteristics. It helps brewers optimize their process and ensure consistent results.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter grain weight in kilograms, mash ratio in liters per kilogram, and sparge water in liters. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical mash ratio for brewing?</strong><br>
                    A: A common mash ratio is 2.5-3.0 liters per kilogram of grain, though this can vary based on the beer style and brewing system.
                </p>
                <p>
                    <strong>Q2: How do I determine the sparge water amount?</strong><br>
                    A: Sparge water is typically calculated based on the desired pre-boil volume minus the first runnings from the mash.
                </p>
                <p>
                    <strong>Q3: Does water temperature affect the calculation?</strong><br>
                    A: While temperature affects mash efficiency, this calculation focuses on volume only. Temperature considerations are separate.
                </p>
                <p>
                    <strong>Q4: Can I use this calculator for different brewing systems?</strong><br>
                    A: Yes, the basic calculation applies to most brewing systems, though specific equipment may require adjustments.
                </p>
                <p>
                    <strong>Q5: How accurate should my measurements be?</strong><br>
                    A: For best results, measure grains to the nearest 0.01kg and water volumes to the nearest 0.1 liter.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Brewing Water Calculator UK© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>