
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculate Fire Water Tank Capacity</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Calculate Fire Water Tank Capacity</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Fire Water Tank Capacity Formula:
                </p>
<div class="formula-container">
    \[ \text{Capacity (gal)} = \frac{\text{Flow rate (gpm)} \times \text{Duration (min)}}{60} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="flow_rate" class="label-box">Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="flow_rate" name="flow_rate" step="0.01" min="0" value="<?php echo isset($_POST['flow_rate']) ? htmlspecialchars($_POST['flow_rate']) : ''; ?>" required>
                                <span class="calc-input">gpm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="duration" class="label-box">Duration:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="duration" name="duration" step="0.01" min="0" value="<?php echo isset($_POST['duration']) ? htmlspecialchars($_POST['duration']) : ''; ?>" required>
                                <span class="calc-input">minutes</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['flow_rate']) && 
                        isset($_POST['duration'])) {
                        
                        // Get input values
                        $flow_rate = floatval($_POST['flow_rate']);
                        $duration = floatval($_POST['duration']);

                        if ($flow_rate > 0 && $duration > 0) {
                            // Calculate capacity
                            $capacity = ($flow_rate * $duration) / 60;
                            $capacity = round($capacity, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Capacity:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($capacity) ? htmlspecialchars($capacity) . " gallons" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Fire Water Tank Capacity Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Fire Water Tank Capacity</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Fire Water Tank Capacity Calculation?</h3>
                <p>
The fire water tank capacity calculation determines the required water storage volume for fire protection systems based on flow rate and duration requirements. This is essential for designing effective fire suppression systems.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Capacity (gal)} = \frac{\text{Flow rate (gpm)} \times \text{Duration (min)}}{60} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Flow rate — Water flow in gallons per minute (gpm)</li>
                        <li>Duration — Required fire suppression time in minutes</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the total water volume needed to maintain a specific flow rate for a designated duration, converting the result to gallons.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Fire Water Tank Capacity</h3>
                <p>
                    <strong>Details:</strong> Properly sized fire water tanks are critical for ensuring adequate water supply during fire emergencies. Undersized tanks can lead to insufficient fire suppression, while oversized tanks increase costs unnecessarily.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the required flow rate in gallons per minute and the desired duration in minutes. Both values must be positive numbers. The calculator will compute the minimum tank capacity needed.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors influence fire water tank capacity requirements?</strong><br>
                    A: Building occupancy type, fire hazard classification, local fire codes, and available water supply all influence capacity requirements.
                </p>
                <p>
                    <strong>Q2: How is flow rate determined for fire protection systems?</strong><br>
                    A: Flow rate is typically determined based on the number and type of fire sprinklers or hydrants needed, calculated according to NFPA standards and local regulations.
                </p>
                <p>
                    <strong>Q3: What is the typical duration requirement for fire water supply?</strong><br>
                    A: Duration requirements vary by jurisdiction and building type but typically range from 30-120 minutes for most occupancies.
                </p>
                <p>
                    <strong>Q4: Should safety factors be applied to the calculated capacity?</strong><br>
                    A: Yes, most fire codes require additional capacity beyond the calculated minimum to account for system inefficiencies and unexpected demands.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for all types of fire protection systems?</strong><br>
                    A: This provides a basic calculation for water storage needs. Specific systems may have additional requirements that should be verified with appropriate standards and local authorities.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Calculate Fire Water Tank Capacity© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
