
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculate Irrigation Water Usage</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Calculate Irrigation Water Usage</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Irrigation Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = \frac{Area \times ET \times Crop\ Factor}{Efficiency} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area_irr" class="label-box">Irrigation Area (Area):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area_irr" name="area_irr" step="0.0001" min="0" value="<?php echo isset($_POST['area_irr']) ? htmlspecialchars($_POST['area_irr']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="ET_irr" class="label-box">Evapotranspiration (ET):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="ET_irr" name="ET_irr" step="0.0001" min="0" value="<?php echo isset($_POST['ET_irr']) ? htmlspecialchars($_POST['ET_irr']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="crop_factor_irr" class="label-box">Crop Factor:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="crop_factor_irr" name="crop_factor_irr" step="0.0001" min="0" value="<?php echo isset($_POST['crop_factor_irr']) ? htmlspecialchars($_POST['crop_factor_irr']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="eff_irr" class="label-box">Irrigation Efficiency:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="eff_irr" name="eff_irr" step="0.0001" min="0.0001" value="<?php echo isset($_POST['eff_irr']) ? htmlspecialchars($_POST['eff_irr']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area_irr']) && 
                        isset($_POST['ET_irr']) &&
                        isset($_POST['crop_factor_irr']) &&
                        isset($_POST['eff_irr'])) {
                        
                        // Get input values
                        $area_irr = floatval($_POST['area_irr']);
                        $ET_irr = floatval($_POST['ET_irr']);
                        $crop_factor_irr = floatval($_POST['crop_factor_irr']);
                        $eff_irr = floatval($_POST['eff_irr']);

                        if ($area_irr > 0 && $ET_irr > 0 && $crop_factor_irr > 0 && $eff_irr > 0) {
                            // Calculate irrigation water usage
                            $usage = ($area_irr * $ET_irr * $crop_factor_irr) / $eff_irr;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Irrigation Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Irrigation Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Irrigation Water Management</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Irrigation Water Usage Calculation?</h3>
                <p>
The irrigation water usage calculation estimates the amount of water required for agricultural irrigation based on area size, evapotranspiration rate, crop-specific factors, and irrigation system efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the irrigation water usage formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \frac{Area \times ET \times Crop\ Factor}{Efficiency} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Area \) — Irrigation area in square meters (m²)</li>
                        <li>\( ET \) — Evapotranspiration rate in millimeters (mm)</li>
                        <li>\( Crop\ Factor \) — Crop-specific coefficient (dimensionless)</li>
                        <li>\( Efficiency \) — Irrigation system efficiency (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the volume of water needed to meet crop water requirements while accounting for system efficiency losses.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Irrigation Water Management</h3>
                <p>
                    <strong>Details:</strong> Proper irrigation water calculation is essential for sustainable agriculture, water conservation, crop yield optimization, and efficient resource management.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter irrigation area in m², evapotranspiration in mm, crop factor (typically 0.5-1.2), and irrigation efficiency (0-1). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is evapotranspiration (ET)?</strong><br>
                    A: ET is the combined process of water evaporation from soil and plant surfaces and transpiration from plants through their leaves.
                </p>
                <p>
                    <strong>Q2: How do I determine the crop factor?</strong><br>
                    A: Crop factors are specific to plant type and growth stage. Consult agricultural extension services or crop-specific research for appropriate values.
                </p>
                <p>
                    <strong>Q3: What is typical irrigation efficiency?</strong><br>
                    A: Efficiency varies by system: drip irrigation (85-90%), sprinklers (70-85%), surface irrigation (60-75%).
                </p>
                <p>
                    <strong>Q4: Why convert mm to m³ in the result?</strong><br>
                    A: 1 mm of water over 1 m² equals 1 liter, so the conversion to m³ provides the total volume needed for the entire area.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for landscape irrigation?</strong><br>
                    A: Yes, the same principles apply to both agricultural and landscape irrigation, though crop factors would be replaced with plant coefficients.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Calculate Irrigation Water Usage© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
