
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculate Water Meter Usage</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Calculate Water Meter Usage</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Meter Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = Current - Previous \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="current" class="label-box">Current Reading (m³):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="current" name="current" step="0.0001" min="0" value="<?php echo isset($_POST['current']) ? htmlspecialchars($_POST['current']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="previous" class="label-box">Previous Reading (m³):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="previous" name="previous" step="0.0001" min="0" value="<?php echo isset($_POST['previous']) ? htmlspecialchars($_POST['previous']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['current']) && 
                        isset($_POST['previous'])) {
                        
                        // Get input values
                        $current = floatval($_POST['current']);
                        $previous = floatval($_POST['previous']);

                        if ($current >= 0 && $previous >= 0 && $current >= $previous) {
                            // Calculate water usage
                            $usage = $current - $previous;
                            $usage = round($usage, 3);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage (m³):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Meter Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Monitoring</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Meter Usage Calculation?</h3>
                <p>
Water meter usage calculation determines the amount of water consumed between two meter readings by subtracting the previous reading from the current reading. This helps in monitoring water consumption and billing accuracy.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the simple formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Current - Previous \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Current \) — Current water meter reading (m³)</li>
                        <li>\( Previous \) — Previous water meter reading (m³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation provides the exact amount of water used during the period between the two readings.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Monitoring</h3>
                <p>
                    <strong>Details:</strong> Regular monitoring helps detect leaks early, promotes water conservation, ensures accurate billing, and provides insights into consumption patterns.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter both current and previous readings in cubic meters (m³). Ensure current reading is greater than or equal to previous reading for accurate results.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What units should I use for the readings?</strong><br>
                    A: The calculator uses cubic meters (m³) as the standard unit for water meter readings.
                </p>
                <p>
                    <strong>Q2: What if my current reading is less than previous?</strong><br>
                    A: This typically indicates an error in reading or meter reset. Please verify your readings and try again.
                </p>
                <p>
                    <strong>Q3: How often should I check my water meter?</strong><br>
                    A: Monthly readings are recommended for accurate consumption tracking and early leak detection.
                </p>
                <p>
                    <strong>Q4: Can I use this for different meter units?</strong><br>
                    A: This calculator is designed for cubic meters. Convert other units to m³ before calculation.
                </p>
                <p>
                    <strong>Q5: Why is my usage higher than expected?</strong><br>
                    A: High usage may indicate leaks, running toilets, or other water wastage. Check your plumbing system.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Calculate Water Meter Usage© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>