
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculate Water Usage</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Calculate Water Usage</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Formula:
                </p>
<div class="formula-container">
    \[ \text{Usage (l/day)} = \text{Sum of daily activities (l)} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower" class="label-box">Shower Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower" name="shower" step="0.1" min="0" value="<?php echo isset($_POST['shower']) ? htmlspecialchars($_POST['shower']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="drinking" class="label-box">Drinking Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="drinking" name="drinking" step="0.1" min="0" value="<?php echo isset($_POST['drinking']) ? htmlspecialchars($_POST['drinking']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="cooking" class="label-box">Cooking Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="cooking" name="cooking" step="0.1" min="0" value="<?php echo isset($_POST['cooking']) ? htmlspecialchars($_POST['cooking']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="cleaning" class="label-box">Cleaning Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="cleaning" name="cleaning" step="0.1" min="0" value="<?php echo isset($_POST['cleaning']) ? htmlspecialchars($_POST['cleaning']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower']) && 
                        isset($_POST['drinking']) &&
                        isset($_POST['cooking']) &&
                        isset($_POST['cleaning'])) {
                        
                        // Get input values
                        $shower = floatval($_POST['shower']);
                        $drinking = floatval($_POST['drinking']);
                        $cooking = floatval($_POST['cooking']);
                        $cleaning = floatval($_POST['cleaning']);

                        if ($shower >= 0 && $drinking >= 0 && $cooking >= 0 && $cleaning >= 0) {
                            // Calculate total water usage
                            $total_usage = $shower + $drinking + $cooking + $cleaning;
                            $total_usage = round($total_usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total_usage) ? htmlspecialchars($total_usage) . " liters/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Tracking</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Usage Calculation?</h3>
                <p>
Water usage calculation measures the total amount of water consumed in various daily activities. Tracking water consumption helps in conservation efforts and understanding personal or household water footprint.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses a simple formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Usage (l/day)} = \text{Sum of daily activities (l)} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Shower Usage — Water used during showers (liters)</li>
                        <li>Drinking Water — Water consumed as beverages (liters)</li>
                        <li>Cooking Usage — Water used in food preparation (liters)</li>
                        <li>Cleaning Usage — Water used for cleaning purposes (liters)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculator sums up water consumption from different daily activities to provide a total daily water usage estimate.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Tracking</h3>
                <p>
                    <strong>Details:</strong> Monitoring water consumption helps identify conservation opportunities, reduces environmental impact, and can lead to significant cost savings on water bills.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water usage for each category in liters. Use water bills or flow measurements for accurate inputs. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the average daily water usage per person?</strong><br>
                    A: The average varies by region but typically ranges between 80-150 liters per person per day in developed countries.
                </p>
                <p>
                    <strong>Q2: How can I reduce my water usage?</strong><br>
                    A: Install water-efficient fixtures, fix leaks promptly, take shorter showers, and use water-saving appliances.
                </p>
                <p>
                    <strong>Q3: Does this calculator include outdoor water usage?</strong><br>
                    A: This version focuses on indoor usage. For complete water footprint, include gardening, car washing, and other outdoor uses.
                </p>
                <p>
                    <strong>Q4: How accurate are these estimates?</strong><br>
                    A: Accuracy depends on the precision of your input measurements. For best results, monitor actual usage over time.
                </p>
                <p>
                    <strong>Q5: Why track water usage in liters?</strong><br>
                    A: Liters are the standard metric unit for water measurement, making it easier to compare with water bills and conservation guidelines.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Calculate Water Usage© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
