
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chilled Water Pump GPM Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Chilled Water Pump GPM Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Chilled Water Pump GPM Formula:
                </p>
<div class="formula-container">
    \[ GPM = \frac{Tons \times 24}{\Delta T} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="tons" class="label-box">Cooling Capacity (Tons):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="tons" name="tons" step="0.0001" min="0" value="<?php echo isset($_POST['tons']) ? htmlspecialchars($_POST['tons']) : ''; ?>" required>
                                <span class="calc-input">tons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="delta_t" class="label-box">Temperature Difference (ΔT):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="delta_t" name="delta_t" step="0.0001" min="0" value="<?php echo isset($_POST['delta_t']) ? htmlspecialchars($_POST['delta_t']) : ''; ?>" required>
                                <span class="calc-input">°F</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['tons']) && 
                        isset($_POST['delta_t'])) {
                        
                        // Get input values
                        $tons = floatval($_POST['tons']);
                        $delta_t = floatval($_POST['delta_t']);

                        if ($tons > 0 && $delta_t > 0) {
                            // Calculate GPM
                            $gpm = ($tons * 24) / $delta_t;
                            $gpm = round($gpm, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Flow Rate (GPM):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($gpm) ? htmlspecialchars($gpm) . " gal/min" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Chilled Water Pump GPM Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of GPM Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Chilled Water Pump GPM Calculation?</h3>
                <p>
The Chilled Water Pump GPM calculation determines the flow rate required for a chilled water system based on cooling capacity and temperature difference. It's essential for proper HVAC system design and pump selection.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ GPM = \frac{Tons \times 24}{\Delta T} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Tons \) — Cooling capacity in tons (1 ton = 12,000 BTU/hr)</li>
                        <li>\( \Delta T \) — Temperature difference between supply and return water (°F)</li>
                        <li>24 — Conversion factor (12,000 BTU/hr/ton ÷ 500 BTU/hr/gpm/°F)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the flow rate needed to transfer the required amount of heat based on the system's cooling capacity and the designed temperature difference.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of GPM Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate GPM calculation is crucial for proper pump selection, ensuring adequate flow for heat transfer, preventing system inefficiencies, and avoiding equipment damage from improper flow rates.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter cooling capacity in tons and temperature difference in °F. Both values must be positive numbers. Typical ΔT values range from 10-20°F for chilled water systems.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is the conversion factor 24?</strong><br>
                    A: The factor 24 comes from (12,000 BTU/hr/ton) ÷ (500 BTU/hr/gpm/°F), which simplifies to 24 gpm/ton/°F.
                </p>
                <p>
                    <strong>Q2: What is a typical ΔT for chilled water systems?</strong><br>
                    A: Most systems are designed for a ΔT of 10-12°F, though some high-efficiency systems may operate at 15-20°F.
                </p>
                <p>
                    <strong>Q3: How does flow rate affect system performance?</strong><br>
                    A: Too low flow can cause poor heat transfer and freezing risks. Too high flow increases pump energy and may cause erosion in pipes.
                </p>
                <p>
                    <strong>Q4: Can this formula be used for other fluids?</strong><br>
                    A: This specific formula is for water. Other fluids would require adjustment for different specific heat capacities.
                </p>
                <p>
                    <strong>Q5: How do I select a pump based on GPM?</strong><br>
                    A: Select a pump that can provide the calculated GPM at the required system pressure, considering pipe friction losses and equipment pressure drops.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Chilled Water Pump GPM Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
