
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>City Of Melbourne Household Water Use Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>City Of Melbourne Household Water Use Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Use Equation:
                </p>
<div class="formula-container">
    \[ use = \sum(daily\_uses \times melbourne\_flow\_rates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower_uses" class="label-box">Shower Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_uses" name="shower_uses" min="0" value="<?php echo isset($_POST['shower_uses']) ? htmlspecialchars($_POST['shower_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_uses" class="label-box">Toilet Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_uses" name="toilet_uses" min="0" value="<?php echo isset($_POST['toilet_uses']) ? htmlspecialchars($_POST['toilet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_uses" class="label-box">Faucet Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_uses" name="faucet_uses" min="0" value="<?php echo isset($_POST['faucet_uses']) ? htmlspecialchars($_POST['faucet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="laundry_uses" class="label-box">Laundry Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="laundry_uses" name="laundry_uses" min="0" value="<?php echo isset($_POST['laundry_uses']) ? htmlspecialchars($_POST['laundry_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower_uses']) && 
                        isset($_POST['toilet_uses']) &&
                        isset($_POST['faucet_uses']) &&
                        isset($_POST['laundry_uses'])) {
                        
                        // Get input values
                        $shower_uses = intval($_POST['shower_uses']);
                        $toilet_uses = intval($_POST['toilet_uses']);
                        $faucet_uses = intval($_POST['faucet_uses']);
                        $laundry_uses = intval($_POST['laundry_uses']);

                        if ($shower_uses >= 0 && $toilet_uses >= 0 && $faucet_uses >= 0 && $laundry_uses >= 0) {
                            // Melbourne flow rates (L/use)
                            $shower_rate = 60;    // L/use
                            $toilet_rate = 9;     // L/use
                            $faucet_rate = 8;     // L/use
                            $laundry_rate = 120;  // L/use
                            
                            // Calculate total water use
                            $total_use = ($shower_uses * $shower_rate) + 
                                        ($toilet_uses * $toilet_rate) + 
                                        ($faucet_uses * $faucet_rate) + 
                                        ($laundry_uses * $laundry_rate);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Use:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total_use) ? htmlspecialchars($total_use) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the City Of Melbourne Household Water Use Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Use Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the City Of Melbourne Household Water Use Calculator?</h3>
                <p>
The City Of Melbourne Household Water Use Calculator estimates daily water consumption based on common household activities using Melbourne-specific flow rates. It helps residents understand and manage their water usage patterns.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water use equation:
                </p>
                <div class="formula-2-container">
                    \[ use = \sum(daily\_uses \times melbourne\_flow\_rates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( daily\_uses \) — Number of uses per day for each activity</li>
                        <li>\( melbourne\_flow\_rates \) — Standard water flow rates for Melbourne (L/use)</li>
                        <li>Shower: 60 L/use</li>
                        <li>Toilet: 9 L/use</li>
                        <li>Faucet: 8 L/use</li>
                        <li>Laundry: 120 L/use</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water consumption by multiplying the frequency of each water-using activity by its standard flow rate and summing all results.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Use Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding household water consumption is essential for water conservation, reducing utility bills, and supporting Melbourne's sustainable water management initiatives.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the daily number of uses for each household activity. All values must be non-negative integers representing typical daily usage.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why use Melbourne-specific flow rates?</strong><br>
                    A: Melbourne has unique water efficiency standards and infrastructure, making local flow rates more accurate for calculating water use in the region.
                </p>
                <p>
                    <strong>Q2: What is considered average water usage in Melbourne?</strong><br>
                    A: The average Melbourne household uses approximately 160-200 liters per person per day, varying by household size and efficiency measures.
                </p>
                <p>
                    <strong>Q3: How can I reduce my water consumption?</strong><br>
                    A: Install water-efficient fixtures, fix leaks promptly, take shorter showers, and only run full loads in washing machines and dishwashers.
                </p>
                <p>
                    <strong>Q4: Are these flow rates applicable to all Melbourne households?</strong><br>
                    A: These are standard averages. Actual consumption may vary based on specific appliance efficiency, water pressure, and usage habits.
                </p>
                <p>
                    <strong>Q5: Does this calculator include outdoor water use?</strong><br>
                    A: This version focuses on indoor household use. Outdoor watering, pools, and other external uses would require additional calculations.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                City Of Melbourne Household Water Use Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
