
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cooling Tower Water Consumption Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Cooling Tower Water Consumption Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Cooling Tower Water Consumption Formula:
                </p>
<div class="formula-container">
    \[ \text{consumption} = \text{evaporation} + \text{drift} + \text{blowdown\_ct} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="evaporation" class="label-box">Evaporation:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="evaporation" name="evaporation" step="0.0001" min="0" value="<?php echo isset($_POST['evaporation']) ? htmlspecialchars($_POST['evaporation']) : ''; ?>" required>
                                <span class="calc-input">m³/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="drift" class="label-box">Drift:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="drift" name="drift" step="0.0001" min="0" value="<?php echo isset($_POST['drift']) ? htmlspecialchars($_POST['drift']) : ''; ?>" required>
                                <span class="calc-input">m³/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="blowdown_ct" class="label-box">Blowdown Ct:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="blowdown_ct" name="blowdown_ct" step="0.0001" min="0" value="<?php echo isset($_POST['blowdown_ct']) ? htmlspecialchars($_POST['blowdown_ct']) : ''; ?>" required>
                                <span class="calc-input">m³/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['evaporation']) && 
                        isset($_POST['drift']) &&
                        isset($_POST['blowdown_ct'])) {
                        
                        // Get input values
                        $evaporation = floatval($_POST['evaporation']);
                        $drift = floatval($_POST['drift']);
                        $blowdown_ct = floatval($_POST['blowdown_ct']);

                        if ($evaporation >= 0 && $drift >= 0 && $blowdown_ct >= 0) {
                            // Calculate consumption
                            $consumption = $evaporation + $drift + $blowdown_ct;
                            $consumption = round($consumption, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($consumption) ? htmlspecialchars($consumption) . " m³/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Cooling Tower Water Consumption?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Consumption Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Cooling Tower Water Consumption?</h3>
                <p>
Cooling tower water consumption refers to the total amount of water used by a cooling tower system, which includes evaporation losses, drift losses, and blowdown requirements to maintain water quality.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{consumption} = \text{evaporation} + \text{drift} + \text{blowdown\_ct} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{evaporation} \) — Water lost through evaporation (m³/day)</li>
                        <li>\( \text{drift} \) — Water lost through drift (m³/day)</li>
                        <li>\( \text{blowdown\_ct} \) — Water intentionally drained to control concentration (m³/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the total water consumption by summing up all major water loss components in a cooling tower system.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Consumption Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water consumption calculation is crucial for water management, cost estimation, environmental compliance, and efficient cooling tower operation.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter evaporation, drift, and blowdown_ct values in m³/day. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is evaporation loss in cooling towers?</strong><br>
                    A: Evaporation loss is the water that turns into vapor during the cooling process, which is the primary mechanism of heat rejection in cooling towers.
                </p>
                <p>
                    <strong>Q2: What is drift loss?</strong><br>
                    A: Drift loss refers to water droplets that are carried out of the cooling tower with the exhaust air, typically minimized with drift eliminators.
                </p>
                <p>
                    <strong>Q3: Why is blowdown necessary?</strong><br>
                    A: Blowdown is necessary to control the concentration of dissolved solids in the cooling water, preventing scale formation and corrosion.
                </p>
                <p>
                    <strong>Q4: How can water consumption be reduced?</strong><br>
                    A: Water consumption can be reduced by optimizing blowdown rates, improving drift elimination, and implementing water recycling systems.
                </p>
                <p>
                    <strong>Q5: What are typical consumption values?</strong><br>
                    A: Consumption values vary based on tower design, operating conditions, and water quality, but typically range from 1-3% of circulating water flow rate.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Cooling Tower Water Consumption Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>