
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cooling Tower Water Usage Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Cooling Tower Water Usage Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = Evaporation + Drift + Blowdown \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="evaporation" class="label-box">Evaporation:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="evaporation" name="evaporation" step="0.0001" min="0" value="<?php echo isset($_POST['evaporation']) ? htmlspecialchars($_POST['evaporation']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="drift" class="label-box">Drift:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="drift" name="drift" step="0.0001" min="0" value="<?php echo isset($_POST['drift']) ? htmlspecialchars($_POST['drift']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="blowdown" class="label-box">Blowdown:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="blowdown" name="blowdown" step="0.0001" min="0" value="<?php echo isset($_POST['blowdown']) ? htmlspecialchars($_POST['blowdown']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['evaporation']) && 
                        isset($_POST['drift']) &&
                        isset($_POST['blowdown'])) {
                        
                        // Get input values
                        $evaporation = floatval($_POST['evaporation']);
                        $drift = floatval($_POST['drift']);
                        $blowdown = floatval($_POST['blowdown']);

                        if ($evaporation >= 0 && $drift >= 0 && $blowdown >= 0) {
                            // Calculate water usage
                            $usage = $evaporation + $drift + $blowdown;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Cooling Tower Water Usage?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Cooling Tower Water Usage?</h3>
                <p>
Cooling tower water usage refers to the total amount of water consumed by a cooling tower system, which includes evaporation losses, drift losses, and blowdown requirements. Understanding water usage is essential for efficient system operation and water conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Evaporation + Drift + Blowdown \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Evaporation \) — Water lost through evaporation (m³)</li>
                        <li>\( Drift \) — Water lost through drift (m³)</li>
                        <li>\( Blowdown \) — Water intentionally drained to control mineral concentration (m³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This equation calculates the total water consumption of a cooling tower system by summing up all the major water loss components.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage calculation is crucial for water management, cost control, environmental compliance, and optimizing cooling tower efficiency. It helps in identifying opportunities for water conservation and reducing operational costs.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter evaporation, drift, and blowdown values in cubic meters (m³). All values must be non-negative numbers. The calculator will sum these values to determine total water usage.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is evaporation loss in cooling towers?</strong><br>
                    A: Evaporation loss is the water that changes from liquid to vapor during the cooling process, typically about 1% of circulating water flow for each 10°F temperature drop.
                </p>
                <p>
                    <strong>Q2: What is drift loss?</strong><br>
                    A: Drift loss is the small droplets of water that are carried out of the cooling tower with the exhaust air, typically 0.001% to 0.005% of circulating water flow.
                </p>
                <p>
                    <strong>Q3: Why is blowdown necessary?</strong><br>
                    A: Blowdown is necessary to control the concentration of dissolved solids in the cooling water by removing a portion of the circulating water, preventing scale formation and corrosion.
                </p>
                <p>
                    <strong>Q4: How can water usage be reduced?</strong><br>
                    A: Water usage can be reduced by optimizing blowdown rates, using water treatment chemicals, installing drift eliminators, and implementing water recycling systems.
                </p>
                <p>
                    <strong>Q5: What factors affect evaporation rate?</strong><br>
                    A: Evaporation rate is affected by cooling load, ambient temperature, humidity, wind speed, and the efficiency of the cooling tower.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Cooling Tower Water Usage Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
