
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cp Of Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Cp Of Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Specific Heat Capacity Formula:
                </p>
<div class="formula-container">
    \[ Cp = 4.184 \times \frac{(T2 - T1)}{m} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="t2" class="label-box">Final Temperature (T2):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="t2" name="t2" step="0.0001" value="<?php echo isset($_POST['t2']) ? htmlspecialchars($_POST['t2']) : ''; ?>" required>
                                <span class="calc-input">°C</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="t1" class="label-box">Initial Temperature (T1):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="t1" name="t1" step="0.0001" value="<?php echo isset($_POST['t1']) ? htmlspecialchars($_POST['t1']) : ''; ?>" required>
                                <span class="calc-input">°C</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="m" class="label-box">Mass (m):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="m" name="m" step="0.0001" min="0" value="<?php echo isset($_POST['m']) ? htmlspecialchars($_POST['m']) : ''; ?>" required>
                                <span class="calc-input">g</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['t2']) && 
                        isset($_POST['t1']) &&
                        isset($_POST['m'])) {
                        
                        // Get input values
                        $t2 = floatval($_POST['t2']);
                        $t1 = floatval($_POST['t1']);
                        $m = floatval($_POST['m']);

                        if ($m > 0) {
                            // Calculate specific heat capacity
                            $cp = 4.184 * ($t2 - $t1) / $m;
                            $cp = round($cp, 4);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Specific Heat Capacity (Cp):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($cp) ? htmlspecialchars($cp) . " J/g°C" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Specific Heat Capacity?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Specific Heat Capacity</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Specific Heat Capacity?</h3>
                <p>
Specific heat capacity (Cp) is the amount of heat energy required to raise the temperature of a unit mass of a substance by one degree Celsius. For water, this value is typically 4.184 J/g°C, making it an excellent heat reservoir.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the specific heat capacity formula:
                </p>
                <div class="formula-2-container">
                    \[ Cp = 4.184 \times \frac{(T2 - T1)}{m} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Cp \) — Specific heat capacity (J/g°C)</li>
                        <li>\( T2 \) — Final temperature (°C)</li>
                        <li>\( T1 \) — Initial temperature (°C)</li>
                        <li>\( m \) — Mass of water (g)</li>
                        <li>4.184 — Specific heat constant for water (J/g°C)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates how much heat energy is required per gram to change water's temperature by a certain amount.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Specific Heat Capacity</h3>
                <p>
                    <strong>Details:</strong> Understanding water's high specific heat capacity is crucial in thermodynamics, climate science, engineering, and many industrial processes where water is used as a coolant or heat transfer medium.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter temperatures in Celsius and mass in grams. Ensure mass is greater than zero and temperature values are valid for accurate calculations.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is water's specific heat capacity important?</strong><br>
                    A: Water's high specific heat capacity allows it to absorb and release large amounts of heat with minimal temperature change, making it ideal for temperature regulation in biological systems and industrial applications.
                </p>
                <p>
                    <strong>Q2: Does specific heat capacity change with temperature?</strong><br>
                    A: For water, the specific heat capacity varies slightly with temperature, but 4.184 J/g°C is the standard value used at room temperature (around 20°C).
                </p>
                <p>
                    <strong>Q3: How does water's specific heat compare to other substances?</strong><br>
                    A: Water has one of the highest specific heat capacities among common substances, which is why it's so effective at storing thermal energy and moderating temperature changes.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for other substances?</strong><br>
                    A: No, this calculator is specifically designed for water using its constant specific heat value of 4.184 J/g°C. Other substances have different specific heat values.
                </p>
                <p>
                    <strong>Q5: What are some practical applications of this calculation?</strong><br>
                    A: This calculation is used in designing heating/cooling systems, calculating energy requirements for industrial processes, environmental science, and understanding heat transfer in various engineering applications.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Cp Of Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>