
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domestic Water Calculations.xls</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Domestic Water Calculations.xls</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Domestic Water Calculation Formula:
                </p>
<div class="formula-container">
    \[ \text{Usage (L/day)} = \sum (\text{Fixture Uses (uses/day)} \times \text{Rates (L/use)}) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixture_uses" class="label-box">Fixture Uses (uses/day):</label>
                            <input class="calc-input" type="number" id="fixture_uses" name="fixture_uses" step="0.01" min="0" value="<?php echo isset($_POST['fixture_uses']) ? htmlspecialchars($_POST['fixture_uses']) : ''; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="rates" class="label-box">Rates (L/use):</label>
                            <input class="calc-input" type="number" id="rates" name="rates" step="0.01" min="0" value="<?php echo isset($_POST['rates']) ? htmlspecialchars($_POST['rates']) : ''; ?>" required>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['fixture_uses']) && 
                        isset($_POST['rates'])) {
                        
                        // Get input values
                        $fixture_uses = floatval($_POST['fixture_uses']);
                        $rates = floatval($_POST['rates']);

                        if ($fixture_uses > 0 && $rates > 0) {
                            // Calculate usage
                            $usage = $fixture_uses * $rates;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage (L/day):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Domestic Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Usage Estimation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Domestic Water Calculation?</h3>
                <p>
Domestic water calculation estimates daily water usage based on fixture usage frequency and water consumption rates. It helps in planning water supply systems and conservation strategies.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Usage (L/day)} = \sum (\text{Fixture Uses (uses/day)} \times \text{Rates (L/use)}) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Fixture Uses} \) — Number of times a fixture is used per day</li>
                        <li>\( \text{Rates} \) — Water consumption per use in liters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation multiplies the daily usage frequency of water fixtures by their respective water consumption rates to estimate total daily water usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Usage Estimation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is essential for designing efficient water supply systems, managing water resources, and implementing water conservation measures.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of fixture uses per day and the water consumption rate per use in liters. Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What types of fixtures can be calculated?</strong><br>
                    A: This calculator can be used for any water fixture including toilets, showers, faucets, and appliances like washing machines and dishwashers.
                </p>
                <p>
                    <strong>Q2: How accurate are these calculations?</strong><br>
                    A: Accuracy depends on the precision of input values. For best results, use average consumption rates and typical usage patterns.
                </p>
                <p>
                    <strong>Q3: Can I calculate multiple fixtures at once?</strong><br>
                    A: This calculator handles one fixture at a time. For multiple fixtures, calculate each separately and sum the results.
                </p>
                <p>
                    <strong>Q4: What are typical water consumption rates?</strong><br>
                    A: Rates vary by fixture: toilets (6-13 L/flush), showers (7.5-15 L/min), faucets (4-8 L/min), washing machines (50-150 L/load).
                </p>
                <p>
                    <strong>Q5: How can I reduce water usage?</strong><br>
                    A: Install water-efficient fixtures, fix leaks promptly, and adopt water-saving habits like shorter showers and full loads in appliances.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Domestic Water Calculations.xls© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>