
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domestic Water Demand Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Domestic Water Demand Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Demand Equation:
                </p>
<div class="formula-container">
    \[ \text{Demand (l/day)} = \text{Population} \times \text{LPCD (l/person/day)} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="population" class="label-box">Population:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="population" name="population" min="0" value="<?php echo isset($_POST['population']) ? htmlspecialchars($_POST['population']) : ''; ?>" required>
                                <span class="calc-input">persons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="lpcd" class="label-box">LPCD:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="lpcd" name="lpcd" step="0.1" min="0" value="<?php echo isset($_POST['lpcd']) ? htmlspecialchars($_POST['lpcd']) : ''; ?>" required>
                                <span class="calc-input">l/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['population']) && 
                        isset($_POST['lpcd'])) {
                        
                        // Get input values
                        $population = floatval($_POST['population']);
                        $lpcd = floatval($_POST['lpcd']);

                        if ($population > 0 && $lpcd > 0) {
                            // Calculate water demand
                            $demand = $population * $lpcd;
                            $demand = round($demand, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Demand:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($demand) ? htmlspecialchars($demand) . " liters/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Domestic Water Demand?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Demand Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Domestic Water Demand?</h3>
                <p>
Domestic water demand refers to the amount of water required for household purposes such as drinking, cooking, bathing, washing, and sanitation. It is typically measured in liters per day and depends on population size and per capita consumption patterns.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water demand equation:
                </p>
                <div class="formula-2-container">
                    \[ \text{Demand (l/day)} = \text{Population} \times \text{LPCD (l/person/day)} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Population} \) — Number of persons</li>
                        <li>\( \text{LPCD} \) — Liters per capita per day (water consumption per person)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total daily water demand by multiplying the population size by the average daily water consumption per person.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Demand Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water demand calculation is essential for urban planning, water supply system design, infrastructure development, and sustainable water resource management. It helps ensure adequate water supply for domestic needs.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter population (number of persons) and LPCD (liters per person per day). Typical LPCD values range from 100-200 l/person/day for urban areas, but may vary based on location and lifestyle.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors affect LPCD values?</strong><br>
                    A: LPCD varies based on climate, economic status, water availability, cultural practices, and efficiency of water use appliances.
                </p>
                <p>
                    <strong>Q2: How does population density affect water demand?</strong><br>
                    A: Higher population density typically leads to higher total water demand, though per capita consumption may vary based on urban vs. rural settings.
                </p>
                <p>
                    <strong>Q3: What is considered a typical LPCD value?</strong><br>
                    A: In developed countries, LPCD typically ranges from 150-300 liters, while in developing countries it may range from 50-150 liters per person per day.
                </p>
                <p>
                    <strong>Q4: How does season affect water demand?</strong><br>
                    A: Water demand often increases during hot/dry seasons due to additional requirements for gardening, cooling, and outdoor activities.
                </p>
                <p>
                    <strong>Q5: Why is accurate water demand calculation important?</strong><br>
                    A: It helps in designing appropriate water supply systems, preventing water shortages, and ensuring sustainable water resource management.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Domestic Water Demand Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>