
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domestic Water Sizing Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Domestic Water Sizing Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Domestic Water Sizing Formula:
                </p>
<div class="formula-container">
    \[ size = peak\_demand \times diversity\_factor \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="peak_demand" class="label-box">Peak Demand:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="peak_demand" name="peak_demand" step="0.0001" min="0" value="<?php echo isset($_POST['peak_demand']) ? htmlspecialchars($_POST['peak_demand']) : ''; ?>" required>
                                <span class="calc-input">L/min</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="diversity_factor" class="label-box">Diversity Factor:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="diversity_factor" name="diversity_factor" step="0.0001" min="0" value="<?php echo isset($_POST['diversity_factor']) ? htmlspecialchars($_POST['diversity_factor']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['peak_demand']) && 
                        isset($_POST['diversity_factor'])) {
                        
                        // Get input values
                        $peak_demand = floatval($_POST['peak_demand']);
                        $diversity_factor = floatval($_POST['diversity_factor']);

                        if ($peak_demand > 0 && $diversity_factor > 0) {
                            // Calculate size
                            $size = $peak_demand * $diversity_factor;
                            $size = round($size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " L/min" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Domestic Water Sizing?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Sizing Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Domestic Water Sizing?</h3>
                <p>
Domestic water sizing is the process of determining the appropriate water system capacity for residential buildings based on peak demand and diversity factors. It ensures adequate water supply while optimizing system efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water sizing equation:
                </p>
                <div class="formula-2-container">
                    \[ size = peak\_demand \times diversity\_factor \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( peak\_demand \) — Maximum expected water flow rate (L/min)</li>
                        <li>\( diversity\_factor \) — Factor accounting for simultaneous usage patterns (dimensionless)</li>
                        <li>\( size \) — Required system capacity (L/min)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the appropriate water system size by multiplying the peak demand by a diversity factor that accounts for the probability of all fixtures being used simultaneously.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Sizing Calculation</h3>
                <p>
                    <strong>Details:</strong> Proper water sizing is crucial for ensuring adequate water supply to all fixtures, preventing pressure drops, optimizing pipe sizing, and reducing installation costs while maintaining system efficiency.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter peak demand in L/min and diversity factor (typically between 0.3-0.7 for residential applications). Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical diversity factor for residential buildings?</strong><br>
                    A: For single-family homes, diversity factors typically range from 0.3 to 0.5. For multi-unit buildings, factors range from 0.4 to 0.7 depending on the number of units.
                </p>
                <p>
                    <strong>Q2: How is peak demand determined?</strong><br>
                    A: Peak demand is calculated by summing the flow rates of all fixtures that might operate simultaneously during periods of maximum usage, typically during morning or evening peak hours.
                </p>
                <p>
                    <strong>Q3: Does this calculation account for future expansion?</strong><br>
                    A: No, this basic calculation provides current requirements. For future expansion, add an appropriate safety factor (typically 10-25%) to the calculated size.
                </p>
                <p>
                    <strong>Q4: Are there different calculation methods for hot and cold water?</strong><br>
                    A: Yes, hot and cold water systems are typically sized separately as they have different usage patterns and peak demand characteristics.
                </p>
                <p>
                    <strong>Q5: How does building height affect water sizing?</strong><br>
                    A: Building height primarily affects pressure requirements rather than flow capacity. Tall buildings may require pressure boosting systems but the flow calculation method remains similar.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Domestic Water Sizing Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
