
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dwelling Insurance Quote Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Dwelling Insurance Quote Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Dwelling Insurance Formula:
                </p>
<div class="formula-container">
    \[ Quote = Dwelling Value \times Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="dwelling_value" class="label-box">Dwelling Value:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dwelling_value" name="dwelling_value" step="0.01" min="0" value="<?php echo isset($_POST['dwelling_value']) ? htmlspecialchars($_POST['dwelling_value']) : ''; ?>" required>
                                <span class="calc-input">currency</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rate" class="label-box">Insurance Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rate" name="rate" step="0.0001" min="0" max="1" value="<?php echo isset($_POST['rate']) ? htmlspecialchars($_POST['rate']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['dwelling_value']) && 
                        isset($_POST['rate'])) {
                        
                        // Get input values
                        $dwelling_value = floatval($_POST['dwelling_value']);
                        $rate = floatval($_POST['rate']);

                        if ($dwelling_value > 0 && $rate > 0) {
                            // Calculate insurance quote
                            $quote = $dwelling_value * $rate;
                            $quote = round($quote, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Insurance Quote:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($quote) ? htmlspecialchars($quote) . " currency" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Dwelling Insurance?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Dwelling Insurance</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Dwelling Insurance?</h3>
                <p>
Dwelling insurance provides coverage for the physical structure of your home against various perils such as fire, theft, and natural disasters. It's a fundamental component of homeowners insurance that protects your most valuable asset.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the dwelling insurance formula:
                </p>
                <div class="formula-2-container">
                    \[ Quote = Dwelling Value \times Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Dwelling Value \) — The estimated replacement cost of your home (currency)</li>
                        <li>\( Rate \) — The insurance rate based on risk factors (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The insurance quote is calculated by multiplying the dwelling value by an insurance rate that reflects the risk level associated with your property.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Dwelling Insurance</h3>
                <p>
                    <strong>Details:</strong> Dwelling insurance is essential for protecting your home investment against unexpected damages. It provides financial security and peace of mind, ensuring you can rebuild or repair your home after covered events.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the estimated replacement value of your dwelling in your local currency and the insurance rate provided by your insurer. Both values must be positive numbers to calculate a valid quote.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors affect the insurance rate?</strong><br>
                    A: Insurance rates vary based on location, construction type, age of home, proximity to fire services, and local crime rates among other factors.
                </p>
                <p>
                    <strong>Q2: How often should I update my dwelling value?</strong><br>
                    A: It's recommended to reassess your dwelling value annually or after major renovations to ensure adequate coverage.
                </p>
                <p>
                    <strong>Q3: What's the difference between market value and replacement cost?</strong><br>
                    A: Market value includes land value and market conditions, while replacement cost refers only to rebuilding the structure itself.
                </p>
                <p>
                    <strong>Q4: Are there discounts available for dwelling insurance?</strong><br>
                    A: Many insurers offer discounts for security systems, fire alarms, bundling policies, and claims-free history.
                </p>
                <p>
                    <strong>Q5: What perils are typically covered by dwelling insurance?</strong><br>
                    A: Standard policies typically cover fire, windstorm, hail, lightning, theft, vandalism, and certain types of water damage.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Dwelling Insurance Quote Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
