
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estimated Water Bill Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Estimated Water Bill Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Bill Formula:
                </p>
<div class="formula-container">
    \[ Bill = Fixed + (Estimated Usage \times Rate) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixed" class="label-box">Fixed Charge:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixed" name="fixed" step="0.01" min="0" value="<?php echo isset($_POST['fixed']) ? htmlspecialchars($_POST['fixed']) : ''; ?>" required>
                                <span class="calc-input">currency</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="estimated_usage" class="label-box">Estimated Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="estimated_usage" name="estimated_usage" step="0.01" min="0" value="<?php echo isset($_POST['estimated_usage']) ? htmlspecialchars($_POST['estimated_usage']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rate" class="label-box">Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rate" name="rate" step="0.0001" min="0" value="<?php echo isset($_POST['rate']) ? htmlspecialchars($_POST['rate']) : ''; ?>" required>
                                <span class="calc-input">currency/m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['fixed']) && 
                        isset($_POST['estimated_usage']) &&
                        isset($_POST['rate'])) {
                        
                        // Get input values
                        $fixed = floatval($_POST['fixed']);
                        $estimated_usage = floatval($_POST['estimated_usage']);
                        $rate = floatval($_POST['rate']);

                        if ($fixed >= 0 && $estimated_usage >= 0 && $rate >= 0) {
                            // Calculate water bill
                            $bill = $fixed + ($estimated_usage * $rate);
                            $bill = round($bill, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Estimated Water Bill:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($bill) ? htmlspecialchars($bill) . " currency" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is The Water Bill Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Bill Estimation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is The Water Bill Calculation?</h3>
                <p>
The water bill calculation estimates your total water charges based on a fixed service fee plus the cost of your estimated water usage. This helps budget for monthly water expenses and understand how usage affects your bill.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water bill formula:
                </p>
                <div class="formula-2-container">
                    \[ Bill = Fixed + (Estimated Usage \times Rate) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Fixed \) — Fixed service charge (currency)</li>
                        <li>\( Estimated Usage \) — Estimated water consumption (m³)</li>
                        <li>\( Rate \) — Cost per unit of water (currency/m³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation separates the fixed infrastructure costs from the variable usage costs, providing a transparent view of your water expenses.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Bill Estimation</h3>
                <p>
                    <strong>Details:</strong> Accurate water bill estimation helps households and businesses budget effectively, identify potential savings through conservation, and understand the cost structure of water services.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the fixed service charge in your local currency, your estimated water usage in cubic meters, and the rate per cubic meter. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is there a fixed charge on water bills?</strong><br>
                    A: The fixed charge covers infrastructure maintenance, meter reading, and administrative costs regardless of water usage.
                </p>
                <p>
                    <strong>Q2: How can I reduce my water bill?</strong><br>
                    A: Reduce usage through conservation measures like fixing leaks, installing low-flow fixtures, and using water-efficient appliances.
                </p>
                <p>
                    <strong>Q3: Are water rates the same for all customers?</strong><br>
                    A: Rates often vary based on customer type (residential, commercial), usage tiers, and sometimes seasonally. Check with your local water provider.
                </p>
                <p>
                    <strong>Q4: How accurate is this estimation?</strong><br>
                    A: This provides a basic estimate. Actual bills may include taxes, surcharges, or tiered pricing not accounted for in this simple calculation.
                </p>
                <p>
                    <strong>Q5: Can I use this for business water billing?</strong><br>
                    A: Yes, though commercial rates may differ from residential rates. Always verify with your water provider for precise business billing information.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Estimated Water Bill Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
