
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estimated Water Usage Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Estimated Water Usage Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = Population \times Per\ Capita\ Use \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="population" class="label-box">Population:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="population" name="population" min="0" value="<?php echo isset($_POST['population']) ? htmlspecialchars($_POST['population']) : ''; ?>" required>
                                <span class="calc-input">people</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="per_capita_use" class="label-box">Per Capita Use:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="per_capita_use" name="per_capita_use" step="0.01" min="0" value="<?php echo isset($_POST['per_capita_use']) ? htmlspecialchars($_POST['per_capita_use']) : ''; ?>" required>
                                <span class="calc-input">L/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['population']) && 
                        isset($_POST['per_capita_use'])) {
                        
                        // Get input values
                        $population = floatval($_POST['population']);
                        $per_capita_use = floatval($_POST['per_capita_use']);

                        if ($population > 0 && $per_capita_use > 0) {
                            // Calculate water usage
                            $usage = $population * $per_capita_use;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Estimated Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Estimation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Usage Calculation?</h3>
                <p>
The water usage calculation estimates total daily water consumption based on population size and per capita water usage. This is essential for water resource planning, infrastructure design, and sustainability assessments.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Population \times Per\ Capita\ Use \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Population \) — Number of people</li>
                        <li>\( Per\ Capita\ Use \) — Water consumption per person per day (L/person/day)</li>
                        <li>\( Usage \) — Total estimated water usage (L/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation multiplies the population by the average daily water consumption per person to estimate total water demand.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Estimation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for municipal planning, water supply system design, conservation efforts, and ensuring adequate water resources for communities.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter population as a whole number and per capita usage in liters per person per day. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is considered typical per capita water usage?</strong><br>
                    A: Typical residential water usage ranges from 100-300 L/person/day, but varies significantly based on location, climate, and lifestyle.
                </p>
                <p>
                    <strong>Q2: Does this calculation include commercial/industrial water use?</strong><br>
                    A: No, this calculates residential water usage only. Commercial and industrial water demands should be calculated separately and added to the total.
                </p>
                <p>
                    <strong>Q3: How accurate is this estimation method?</strong><br>
                    A: It provides a good baseline estimate, but actual usage may vary based on seasonal factors, conservation measures, and local water policies.
                </p>
                <p>
                    <strong>Q4: Should I use average or peak usage values?</strong><br>
                    A: For infrastructure planning, use peak usage values. For overall resource planning, average values are more appropriate.
                </p>
                <p>
                    <strong>Q5: How can water usage be reduced?</strong><br>
                    A: Through water-efficient appliances, leak detection and repair, rainwater harvesting, and public awareness campaigns about water conservation.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Estimated Water Usage Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>