
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Garden Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Garden Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Garden Water Equation:
                </p>
<div class="formula-container">
    \[ Water = Garden Area \times Garden Rate \times Time \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="garden_area" class="label-box">Garden Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="garden_area" name="garden_area" step="0.01" min="0" value="<?php echo isset($_POST['garden_area']) ? htmlspecialchars($_POST['garden_area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="garden_rate" class="label-box">Garden Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="garden_rate" name="garden_rate" step="0.01" min="0" value="<?php echo isset($_POST['garden_rate']) ? htmlspecialchars($_POST['garden_rate']) : ''; ?>" required>
                                <span class="calc-input">mm/h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time_garden" class="label-box">Time:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time_garden" name="time_garden" step="0.01" min="0" value="<?php echo isset($_POST['time_garden']) ? htmlspecialchars($_POST['time_garden']) : ''; ?>" required>
                                <span class="calc-input">h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['garden_area']) && 
                        isset($_POST['garden_rate']) &&
                        isset($_POST['time_garden'])) {
                        
                        // Get input values
                        $garden_area = floatval($_POST['garden_area']);
                        $garden_rate = floatval($_POST['garden_rate']);
                        $time_garden = floatval($_POST['time_garden']);

                        if ($garden_area > 0 && $garden_rate > 0 && $time_garden > 0) {
                            // Calculate water usage
                            $water = $garden_area * $garden_rate * $time_garden;
                            $water = round($water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water) ? htmlspecialchars($water) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Garden Water Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Garden Water Calculator?</h3>
                <p>
The Garden Water Calculator estimates the amount of water needed for garden irrigation based on garden area, watering rate, and time. It helps in efficient water management for gardening purposes.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the garden water equation:
                </p>
                <div class="formula-2-container">
                    \[ Water = Garden Area \times Garden Rate \times Time \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Garden Area \) — Area of the garden in square meters (m²)</li>
                        <li>\( Garden Rate \) — Watering rate in millimeters per hour (mm/h)</li>
                        <li>\( Time \) — Watering time in hours (h)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total volume of water needed by multiplying the garden area by the watering rate and the duration of watering.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water calculation is crucial for efficient garden irrigation, water conservation, and ensuring plants receive adequate hydration without wastage.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter garden area in square meters, watering rate in millimeters per hour, and time in hours. All values must be valid (greater than 0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why calculate garden water usage?</strong><br>
                    A: Calculating water usage helps in efficient irrigation planning, reduces water waste, and ensures plants get the right amount of water.
                </p>
                <p>
                    <strong>Q2: What is a typical garden watering rate?</strong><br>
                    A: Typical watering rates vary by plant type and soil conditions, but generally range from 10-25 mm/h for most gardens.
                </p>
                <p>
                    <strong>Q3: How often should I water my garden?</strong><br>
                    A: Watering frequency depends on climate, soil type, and plant needs. Generally, 1-2 times per week is sufficient for most gardens.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this calculation?</strong><br>
                    A: This calculation provides an estimate. Actual water needs may vary based on soil absorption, weather conditions, and specific plant requirements.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for lawns?</strong><br>
                    A: Yes, the same calculation applies to lawns and other landscaped areas requiring irrigation.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Garden Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
