
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mass Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Mass Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Mass Formula:
                </p>
<div class="formula-container">
    \[ \text{Mass (g)} = \text{Density (g/cm³)} \times \text{Volume (cm³)} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="density" class="label-box">Density:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="density" name="density" step="0.0001" min="0" value="<?php echo isset($_POST['density']) ? htmlspecialchars($_POST['density']) : ''; ?>" required>
                                <span class="calc-input">g/cm³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="volume" class="label-box">Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="volume" name="volume" step="0.0001" min="0" value="<?php echo isset($_POST['volume']) ? htmlspecialchars($_POST['volume']) : ''; ?>" required>
                                <span class="calc-input">cm³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['density']) && 
                        isset($_POST['volume'])) {
                        
                        // Get input values
                        $density = floatval($_POST['density']);
                        $volume = floatval($_POST['volume']);

                        if ($density > 0 && $volume > 0) {
                            // Calculate mass
                            $mass = $density * $volume;
                            $mass = round($mass, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Mass:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($mass) ? htmlspecialchars($mass) . " g" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Mass Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Mass Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Mass Calculation?</h3>
                <p>
Mass calculation determines the amount of matter in an object using the formula: Mass = Density × Volume. This fundamental physics principle is essential in various scientific and engineering applications.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the mass formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Mass (g)} = \text{Density (g/cm³)} \times \text{Volume (cm³)} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Mass — The amount of matter in an object (grams)</li>
                        <li>Density — Mass per unit volume (g/cm³)</li>
                        <li>Volume — The space occupied by an object (cm³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates mass by multiplying the density of a substance by its volume, providing the total mass in grams.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Mass Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate mass calculation is crucial for material science, chemistry experiments, engineering designs, and various industrial applications where precise measurements are required.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter density in g/cm³ and volume in cm³. Both values must be positive numbers. The calculator will compute the mass in grams.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the standard unit for mass calculation?</strong><br>
                    A: While grams are commonly used, mass can be calculated in any unit as long as density and volume units are consistent (e.g., kg/m³ and m³ for kilograms).
                </p>
                <p>
                    <strong>Q2: How does temperature affect density?</strong><br>
                    A: Density typically decreases with increasing temperature for most substances, as molecules spread out and occupy more space.
                </p>
                <p>
                    <strong>Q3: Can this formula be used for all materials?</strong><br>
                    A: Yes, the formula applies to all materials, but the density value must be appropriate for the specific substance at the given conditions.
                </p>
                <p>
                    <strong>Q4: What's the density of water?</strong><br>
                    A: Pure water has a density of approximately 1 g/cm³ at 4°C, which is often used as a reference point.
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: The accuracy depends on the precision of your density and volume measurements. For most practical purposes, this formula provides excellent results.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Mass Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
