
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home Insurance Premium Calculator Nepal</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Home Insurance Premium Calculator Nepal</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Home Insurance Premium Formula:
                </p>
<div class="formula-container">
    \[ Premium = Home\ Value \times Nepal\ Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="home_value" class="label-box">Home Value:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="home_value" name="home_value" step="0.01" min="0" value="<?php echo isset($_POST['home_value']) ? htmlspecialchars($_POST['home_value']) : ''; ?>" required>
                                <span class="calc-input">NPR</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="nepal_rate" class="label-box">Nepal Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="nepal_rate" name="nepal_rate" step="0.0001" min="0" value="<?php echo isset($_POST['nepal_rate']) ? htmlspecialchars($_POST['nepal_rate']) : ''; ?>" required>
                                <span class="calc-input">%</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['home_value']) && 
                        isset($_POST['nepal_rate'])) {
                        
                        // Get input values
                        $home_value = floatval($_POST['home_value']);
                        $nepal_rate = floatval($_POST['nepal_rate']);

                        if ($home_value > 0 && $nepal_rate > 0) {
                            // Calculate premium
                            $premium = $home_value * ($nepal_rate / 100);
                            $premium = round($premium, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Insurance Premium:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($premium) ? "NPR " . htmlspecialchars(number_format($premium, 2)) : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Home Insurance Premium Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Premium Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Home Insurance Premium Calculation?</h3>
                <p>
Home insurance premium calculation in Nepal is based on the property value and the applicable insurance rate. This helps homeowners determine the cost of protecting their property against various risks and damages.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the simple formula:
                </p>
                <div class="formula-2-container">
                    \[ Premium = Home\ Value \times Nepal\ Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Home\ Value \) — The total value of the home property (NPR)</li>
                        <li>\( Nepal\ Rate \) — The insurance rate percentage applicable in Nepal (%)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The premium is calculated by multiplying the home value by the insurance rate (converted from percentage to decimal).
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Premium Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate premium calculation helps homeowners budget for insurance costs and ensures proper coverage for their property investments in Nepal.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the home value in Nepalese Rupees (NPR) and the insurance rate as a percentage. Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors affect the Nepal insurance rate?</strong><br>
                    A: Insurance rates in Nepal may vary based on location, construction type, property age, and risk factors specific to the region.
                </p>
                <p>
                    <strong>Q2: Is this calculation applicable throughout Nepal?</strong><br>
                    A: While the basic formula applies, actual rates may vary by insurance provider and specific region within Nepal.
                </p>
                <p>
                    <strong>Q3: What does home insurance typically cover in Nepal?</strong><br>
                    A: Typically covers damage from fire, natural disasters, theft, and other specified perils as per the policy terms.
                </p>
                <p>
                    <strong>Q4: How often should I review my home insurance premium?</strong><br>
                    A: It's recommended to review your insurance coverage annually or when making significant changes to your property.
                </p>
                <p>
                    <strong>Q5: Are there any discounts available on home insurance in Nepal?</strong><br>
                    A: Many insurers offer discounts for security systems, claim-free years, and bundled insurance policies.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Home Insurance Premium Calculator Nepal© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>