
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home Water Usage Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Home Water Usage Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = \sum (DailyUses \times FlowRates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower_uses" class="label-box">Shower Uses (per day):</label>
                            <input class="calc-input" type="number" id="shower_uses" name="shower_uses" min="0" value="<?php echo isset($_POST['shower_uses']) ? htmlspecialchars($_POST['shower_uses']) : '0'; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="shower_flow" class="label-box">Shower Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_flow" name="shower_flow" step="0.1" min="0" value="<?php echo isset($_POST['shower_flow']) ? htmlspecialchars($_POST['shower_flow']) : '0'; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_uses" class="label-box">Faucet Uses (per day):</label>
                            <input class="calc-input" type="number" id="faucet_uses" name="faucet_uses" min="0" value="<?php echo isset($_POST['faucet_uses']) ? htmlspecialchars($_POST['faucet_uses']) : '0'; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="faucet_flow" class="label-box">Faucet Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_flow" name="faucet_flow" step="0.1" min="0" value="<?php echo isset($_POST['faucet_flow']) ? htmlspecialchars($_POST['faucet_flow']) : '0'; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_uses" class="label-box">Toilet Uses (per day):</label>
                            <input class="calc-input" type="number" id="toilet_uses" name="toilet_uses" min="0" value="<?php echo isset($_POST['toilet_uses']) ? htmlspecialchars($_POST['toilet_uses']) : '0'; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="toilet_flow" class="label-box">Toilet Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_flow" name="toilet_flow" step="0.1" min="0" value="<?php echo isset($_POST['toilet_flow']) ? htmlspecialchars($_POST['toilet_flow']) : '0'; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST") {
                        $shower_uses = isset($_POST['shower_uses']) ? floatval($_POST['shower_uses']) : 0;
                        $shower_flow = isset($_POST['shower_flow']) ? floatval($_POST['shower_flow']) : 0;
                        $faucet_uses = isset($_POST['faucet_uses']) ? floatval($_POST['faucet_uses']) : 0;
                        $faucet_flow = isset($_POST['faucet_flow']) ? floatval($_POST['faucet_flow']) : 0;
                        $toilet_uses = isset($_POST['toilet_uses']) ? floatval($_POST['toilet_uses']) : 0;
                        $toilet_flow = isset($_POST['toilet_flow']) ? floatval($_POST['toilet_flow']) : 0;
                        
                        // Calculate total water usage
                        $total_usage = ($shower_uses * $shower_flow) + 
                                      ($faucet_uses * $faucet_flow) + 
                                      ($toilet_uses * $toilet_flow);
                        $total_usage = round($total_usage, 1);
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Usage:</label>
                        <div class="input-with-unit">
                            <input class="calc-input" type="text" value='<?php echo isset($total_usage) ? htmlspecialchars($total_usage) : ""; ?>' readonly>
                            <span class="calc-input">L/day</span>
                        </div>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Home Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Monitoring</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Home Water Usage Calculation?</h3>
                <p>
Home water usage calculation estimates the total amount of water consumed daily in a household by considering various water-consuming activities and their respective flow rates.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum (DailyUses \times FlowRates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( DailyUses \) — Number of times a water fixture is used per day</li>
                        <li>\( FlowRates \) — Water consumption per use (liters)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water usage by summing the products of daily usage frequency and flow rate for each water-consuming activity.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Monitoring</h3>
                <p>
                    <strong>Details:</strong> Monitoring home water usage helps in conservation efforts, reduces utility bills, and promotes sustainable living practices by identifying areas where water consumption can be optimized.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of daily uses and flow rates for showers, faucets, and toilets. All values must be valid (non-negative numbers). For accuracy, measure flow rates or use standard values (shower: 9-15 L/min, faucet: 6-11 L/min, toilet: 6-13 L/flush).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why calculate home water usage?</strong><br>
                    A: Calculating water usage helps identify consumption patterns, detect leaks, and implement water-saving measures to reduce environmental impact and utility costs.
                </p>
                <p>
                    <strong>Q2: What are typical flow rates for household fixtures?</strong><br>
                    A: Standard showerheads use 9-15 liters per minute, faucets 6-11 liters per minute, and toilets 6-13 liters per flush. Low-flow fixtures use less water.
                </p>
                <p>
                    <strong>Q3: How can I reduce my water usage?</strong><br>
                    A: Install low-flow fixtures, fix leaks promptly, take shorter showers, and turn off faucets when not in use. Also, consider collecting rainwater for outdoor use.
                </p>
                <p>
                    <strong>Q4: Does this calculator account for all water usage?</strong><br>
                    A: This calculator covers major indoor uses. Additional sources like outdoor watering, dishwasher, and washing machine usage should be added for a complete picture.
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: Accuracy depends on the precision of your usage estimates and flow rate measurements. For best results, measure flow rates directly or use manufacturer specifications.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Home Water Usage Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
