
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hot Water Boiler Size Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Hot Water Boiler Size Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Boiler Size Formula:
                </p>
<div class="formula-container">
    \[ \text{size} = \frac{\text{heat\_demand}}{\text{efficiency}} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="heat_demand" class="label-box">Heat Demand (heat_demand):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="heat_demand" name="heat_demand" step="0.0001" min="0" value="<?php echo isset($_POST['heat_demand']) ? htmlspecialchars($_POST['heat_demand']) : ''; ?>" required>
                                <span class="calc-input">kW</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="efficiency" class="label-box">Efficiency (efficiency):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="efficiency" name="efficiency" step="0.0001" min="0" max="1" value="<?php echo isset($_POST['efficiency']) ? htmlspecialchars($_POST['efficiency']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['heat_demand']) && 
                        isset($_POST['efficiency'])) {
                        
                        // Get input values
                        $heat_demand = floatval($_POST['heat_demand']);
                        $efficiency = floatval($_POST['efficiency']);

                        if ($heat_demand > 0 && $efficiency > 0 && $efficiency <= 1) {
                            // Calculate boiler size
                            $size = $heat_demand / $efficiency;
                            $size = round($size, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Boiler Size (size):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " kW" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Hot Water Boiler Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Boiler Size Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Hot Water Boiler Size Calculation?</h3>
                <p>
The boiler size calculation determines the required capacity of a hot water boiler based on the heat demand and system efficiency. Proper sizing ensures optimal performance and energy efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the boiler size formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{size} = \frac{\text{heat\_demand}}{\text{efficiency}} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{size} \) — Boiler size (kW)</li>
                        <li>\( \text{heat\_demand} \) — Required heat output (kW)</li>
                        <li>\( \text{efficiency} \) — System efficiency (dimensionless, 0-1)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the actual boiler capacity needed by accounting for system efficiency losses.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Boiler Size Calculation</h3>
                <p>
                    <strong>Details:</strong> Proper boiler sizing is crucial for energy efficiency, operational cost savings, and ensuring adequate heating capacity without oversizing.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter heat demand in kW and efficiency as a decimal between 0 and 1. All values must be valid (heat_demand > 0, 0 < efficiency ≤ 1).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is boiler efficiency important in sizing?</strong><br>
                    A: Efficiency accounts for energy losses in the system, ensuring the boiler has sufficient capacity to meet the actual heat demand.
                </p>
                <p>
                    <strong>Q2: What is a typical efficiency value for boilers?</strong><br>
                    A: Modern boilers typically have efficiencies between 0.85-0.95 (85-95%), while older models may be lower.
                </p>
                <p>
                    <strong>Q3: How do I determine the heat demand for my building?</strong><br>
                    A: Heat demand is calculated based on building size, insulation, climate, and desired temperature. Professional heat loss calculations are recommended.
                </p>
                <p>
                    <strong>Q4: What happens if a boiler is oversized?</strong><br>
                    A: Oversized boilers operate less efficiently, have higher initial costs, and may experience short cycling, reducing equipment lifespan.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for steam boilers?</strong><br>
                    A: This calculator is designed for hot water boilers. Steam boiler sizing requires additional factors and different calculations.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Hot Water Boiler Size Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>