
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hot Water Consumption Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Hot Water Consumption Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Hot Water Consumption Formula:
                </p>
<div class="formula-container">
    \[ \text{Consumption (l/day)} = \sum (\text{fixture uses} \times \text{frequency}) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower" class="label-box">Shower Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower" name="shower" min="0" value="<?php echo isset($_POST['shower']) ? htmlspecialchars($_POST['shower']) : '0'; ?>" required>
                                <span class="calc-input">times/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="bath" class="label-box">Bath Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="bath" name="bath" min="0" value="<?php echo isset($_POST['bath']) ? htmlspecialchars($_POST['bath']) : '0'; ?>" required>
                                <span class="calc-input">times/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dishwashing" class="label-box">Dishwashing:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dishwashing" name="dishwashing" min="0" value="<?php echo isset($_POST['dishwashing']) ? htmlspecialchars($_POST['dishwashing']) : '0'; ?>" required>
                                <span class="calc-input">times/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="laundry" class="label-box">Laundry:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="laundry" name="laundry" min="0" value="<?php echo isset($_POST['laundry']) ? htmlspecialchars($_POST['laundry']) : '0'; ?>" required>
                                <span class="calc-input">times/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower']) && 
                        isset($_POST['bath']) &&
                        isset($_POST['dishwashing']) &&
                        isset($_POST['laundry'])) {
                        
                        // Get input values
                        $shower = intval($_POST['shower']);
                        $bath = intval($_POST['bath']);
                        $dishwashing = intval($_POST['dishwashing']);
                        $laundry = intval($_POST['laundry']);

                        // Standard water consumption per use (liters)
                        $shower_consumption = 60; // liters per shower
                        $bath_consumption = 120;  // liters per bath
                        $dishwashing_consumption = 30; // liters per session
                        $laundry_consumption = 100; // liters per load
                        
                        // Calculate total consumption
                        $total_consumption = ($shower * $shower_consumption) + 
                                            ($bath * $bath_consumption) + 
                                            ($dishwashing * $dishwashing_consumption) + 
                                            ($laundry * $laundry_consumption);
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total_consumption) ? htmlspecialchars($total_consumption) . " liters/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Hot Water Consumption Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Consumption Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Hot Water Consumption Calculation?</h3>
                <p>
Hot water consumption calculation estimates the daily usage of hot water based on various household activities. It helps in sizing water heaters, planning energy requirements, and promoting water conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the following formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Consumption (l/day)} = \sum (\text{fixture uses} \times \text{frequency}) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Shower — 60 liters per use</li>
                        <li>Bath — 120 liters per use</li>
                        <li>Dishwashing — 30 liters per session</li>
                        <li>Laundry — 100 liters per load</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation sums up the water consumption from all household activities that use hot water.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Consumption Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate hot water consumption estimation is crucial for proper water heater sizing, energy efficiency planning, and reducing utility costs.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of times each activity is performed daily. The calculator will sum the total hot water consumption in liters per day.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Are these consumption values accurate for all households?</strong><br>
                    A: These are average values. Actual consumption may vary based on fixture efficiency, user habits, and other factors.
                </p>
                <p>
                    <strong>Q2: How can I reduce my hot water consumption?</strong><br>
                    A: Use low-flow showerheads, fix leaks promptly, wash clothes in cold water when possible, and run full loads in dishwasher and washing machine.
                </p>
                <p>
                    <strong>Q3: Why is hot water consumption important for energy planning?</strong><br>
                    A: Heating water accounts for a significant portion of home energy use. Knowing consumption helps size systems properly and reduce energy waste.
                </p>
                <p>
                    <strong>Q4: Should I include outdoor water usage?</strong><br>
                    A: This calculator focuses on indoor hot water usage. Outdoor usage typically doesn't require heated water.
                </p>
                <p>
                    <strong>Q5: How often should I reassess my hot water needs?</strong><br>
                    A: Reassess when household size changes, after installing water-efficient fixtures, or when noticing changes in water heating performance.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Hot Water Consumption Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
