
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hot Water Demand Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Hot Water Demand Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Hot Water Demand Formula:
                </p>
<div class="formula-container">
    \[ demand = persons \times (hot\_water\_per\_person + adjustment) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="persons" class="label-box">Number of Persons:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="persons" name="persons" min="1" value="<?php echo isset($_POST['persons']) ? htmlspecialchars($_POST['persons']) : ''; ?>" required>
                                <span class="calc-input">persons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="hot_water_per_person" class="label-box">Hot Water per Person:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="hot_water_per_person" name="hot_water_per_person" step="0.1" min="0" value="<?php echo isset($_POST['hot_water_per_person']) ? htmlspecialchars($_POST['hot_water_per_person']) : ''; ?>" required>
                                <span class="calc-input">L/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="adjustment" class="label-box">Adjustment:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="adjustment" name="adjustment" step="0.1" value="<?php echo isset($_POST['adjustment']) ? htmlspecialchars($_POST['adjustment']) : '0'; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['persons']) && 
                        isset($_POST['hot_water_per_person']) &&
                        isset($_POST['adjustment'])) {
                        
                        // Get input values
                        $persons = intval($_POST['persons']);
                        $hot_water_per_person = floatval($_POST['hot_water_per_person']);
                        $adjustment = floatval($_POST['adjustment']);

                        if ($persons > 0 && $hot_water_per_person >= 0) {
                            // Calculate hot water demand
                            $demand = $persons * ($hot_water_per_person + $adjustment);
                            $demand = round($demand, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Hot Water Demand:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($demand) ? htmlspecialchars($demand) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Hot Water Demand Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Hot Water Demand Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Hot Water Demand Calculation?</h3>
                <p>
Hot water demand calculation estimates the daily hot water requirements based on the number of persons and their individual usage patterns. This calculation is essential for proper sizing of water heating systems and ensuring adequate hot water supply.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the hot water demand formula:
                </p>
                <div class="formula-2-container">
                    \[ demand = persons \times (hot\_water\_per\_person + adjustment) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( persons \) — Number of persons</li>
                        <li>\( hot\_water\_per\_person \) — Hot water consumption per person per day (L/person/day)</li>
                        <li>\( adjustment \) — Additional adjustment factor (L/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total hot water demand by multiplying the number of persons with their individual consumption plus any additional adjustment factor.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Hot Water Demand Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate hot water demand calculation is crucial for proper sizing of water heaters, energy efficiency planning, and ensuring adequate hot water supply for residential and commercial buildings.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of persons, hot water consumption per person in liters per day, and any additional adjustment factor. All values must be valid (persons > 0, hot water per person ≥ 0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical hot water consumption per person?</strong><br>
                    A: Typical consumption ranges from 40-80 liters per person per day, depending on usage habits and appliances.
                </p>
                <p>
                    <strong>Q2: What does the adjustment factor represent?</strong><br>
                    A: The adjustment factor accounts for additional hot water needs such as guest usage, special appliances, or safety margins.
                </p>
                <p>
                    <strong>Q3: How does this calculation help in system sizing?</strong><br>
                    A: It helps determine the appropriate capacity of water heaters and storage tanks to meet daily demand requirements.
                </p>
                <p>
                    <strong>Q4: Are there seasonal variations in hot water demand?</strong><br>
                    A: Yes, hot water demand typically increases in colder months and may vary based on climate and usage patterns.
                </p>
                <p>
                    <strong>Q5: Should this calculation consider peak usage times?</strong><br>
                    A: For comprehensive system design, both daily demand and peak hourly demand should be considered.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Hot Water Demand Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>