
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hot Water Heating Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Hot Water Heating Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Hot Water Heating Equation:
                </p>
<div class="formula-container">
    \[ Q = m \times C_p \times \Delta T \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="mass" class="label-box">Mass (m):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="mass" name="mass" step="0.0001" min="0" value="<?php echo isset($_POST['mass']) ? htmlspecialchars($_POST['mass']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="cp" class="label-box">Specific Heat Capacity (Cp):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="cp" name="cp" step="0.0001" min="0" value="<?php echo isset($_POST['cp']) ? htmlspecialchars($_POST['cp']) : '4184'; ?>" required>
                                <span class="calc-input">J/kg°C</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="delta_t" class="label-box">Temperature Change (ΔT):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="delta_t" name="delta_t" step="0.0001" value="<?php echo isset($_POST['delta_t']) ? htmlspecialchars($_POST['delta_t']) : ''; ?>" required>
                                <span class="calc-input">°C</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['mass']) && 
                        isset($_POST['cp']) &&
                        isset($_POST['delta_t'])) {
                        
                        // Get input values
                        $mass = floatval($_POST['mass']);
                        $cp = floatval($_POST['cp']);
                        $delta_t = floatval($_POST['delta_t']);

                        if ($mass > 0 && $cp > 0) {
                            // Calculate heat energy
                            $q = $mass * $cp * $delta_t;
                            $q = round($q, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Heat Energy (Q):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($q) ? htmlspecialchars($q) . " J" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Hot Water Heating Equation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Heat Energy Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Hot Water Heating Equation?</h3>
                <p>
The hot water heating equation calculates the amount of heat energy required to raise the temperature of water. It's based on the fundamental thermodynamic principle of specific heat capacity.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the heat energy equation:
                </p>
                <div class="formula-2-container">
                    \[ Q = m \times C_p \times \Delta T \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Q \) — Heat energy (Joules)</li>
                        <li>\( m \) — Mass of water (kg)</li>
                        <li>\( C_p \) — Specific heat capacity of water (4184 J/kg°C)</li>
                        <li>\( \Delta T \) — Temperature change (°C)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the thermal energy required to change the temperature of a given mass of water by a specific amount.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Heat Energy Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate heat energy calculation is crucial for designing heating systems, energy efficiency calculations, and understanding thermal processes in various applications.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter mass in kg, specific heat capacity in J/kg°C (default 4184 for water), and temperature change in °C. All values must be valid (mass > 0, Cp > 0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is specific heat capacity important?</strong><br>
                    A: Specific heat capacity determines how much energy is required to raise the temperature of a substance. Water has a high specific heat capacity compared to other substances.
                </p>
                <p>
                    <strong>Q2: What are typical values for water heating?</strong><br>
                    A: For residential water heating, typical values range from 150-300 liters (150-300 kg) with temperature rises of 30-50°C.
                </p>
                <p>
                    <strong>Q3: Can this calculator be used for other liquids?</strong><br>
                    A: Yes, by changing the specific heat capacity value to match the liquid being heated.
                </p>
                <p>
                    <strong>Q4: How does this relate to energy consumption?</strong><br>
                    A: The calculated heat energy can be converted to kWh to estimate electrical energy consumption for water heating.
                </p>
                <p>
                    <strong>Q5: What factors affect heating efficiency?</strong><br>
                    A: Insulation quality, heating element efficiency, and heat loss to surroundings all affect the actual energy required.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Hot Water Heating Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>