
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Household Water Footprint Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Household Water Footprint Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Equation:
                </p>
<div class="formula-container">
    \[ WF = direct + virtual\_household \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct" class="label-box">Direct Water Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct" name="direct" step="0.01" min="0" value="<?php echo isset($_POST['direct']) ? htmlspecialchars($_POST['direct']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_household" class="label-box">Virtual Household Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_household" name="virtual_household" step="0.01" min="0" value="<?php echo isset($_POST['virtual_household']) ? htmlspecialchars($_POST['virtual_household']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct']) && 
                        isset($_POST['virtual_household'])) {
                        
                        // Get input values
                        $direct = floatval($_POST['direct']);
                        $virtual_household = floatval($_POST['virtual_household']);

                        if ($direct >= 0 && $virtual_household >= 0) {
                            // Calculate water footprint
                            $wf = $direct + $virtual_household;
                            $wf = round($wf, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($wf) ? htmlspecialchars($wf) . " gallons/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Household Water Footprint?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Household Water Footprint?</h3>
                <p>
The household water footprint measures the total volume of freshwater used directly and indirectly by a household. It includes both direct water consumption (from taps, showers, etc.) and virtual water (embedded in products and services consumed by the household).
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water footprint equation:
                </p>
                <div class="formula-2-container">
                    \[ WF = direct + virtual\_household \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( direct \) — Direct water usage (gallons/day)</li>
                        <li>\( virtual\_household \) — Virtual household water (gallons/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water footprint by summing direct water consumption and virtual water usage associated with household activities and consumption patterns.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding your household water footprint helps identify water conservation opportunities, promotes sustainable water use, and contributes to global water resource management efforts.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter direct water usage and virtual household water in gallons per day. Both values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is considered direct water usage?</strong><br>
                    A: Direct water usage includes all water directly consumed from taps, showers, toilets, and outdoor uses like gardening and car washing.
                </p>
                <p>
                    <strong>Q2: What is virtual household water?</strong><br>
                    A: Virtual water represents the water embedded in products and services consumed by the household, including food, clothing, energy, and other goods.
                </p>
                <p>
                    <strong>Q3: What is an average household water footprint?</strong><br>
                    A: The average varies significantly by region and lifestyle, but typical households use hundreds to thousands of gallons per day when considering both direct and virtual water.
                </p>
                <p>
                    <strong>Q4: How can I reduce my water footprint?</strong><br>
                    A: Implement water-saving fixtures, fix leaks, choose water-efficient products, reduce meat consumption, and be mindful of the water embedded in purchased goods.
                </p>
                <p>
                    <strong>Q5: Why measure water footprint in gallons per day?</strong><br>
                    A: Daily measurement provides a consistent timeframe for comparison and helps track conservation efforts over time.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Household Water Footprint Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
