
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Household Water Use Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Household Water Use Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Formula:
                </p>
<div class="formula-container">
    \[ \text{Usage} = \sum(\text{Daily Uses} \times \text{Flow Rates}) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower_uses" class="label-box">Shower Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_uses" name="shower_uses" min="0" value="<?php echo isset($_POST['shower_uses']) ? htmlspecialchars($_POST['shower_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="shower_flow" class="label-box">Shower Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_flow" name="shower_flow" step="0.1" min="0" value="<?php echo isset($_POST['shower_flow']) ? htmlspecialchars($_POST['shower_flow']) : ''; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_uses" class="label-box">Faucet Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_uses" name="faucet_uses" min="0" value="<?php echo isset($_POST['faucet_uses']) ? htmlspecialchars($_POST['faucet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_flow" class="label-box">Faucet Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_flow" name="faucet_flow" step="0.1" min="0" value="<?php echo isset($_POST['faucet_flow']) ? htmlspecialchars($_POST['faucet_flow']) : ''; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_uses" class="label-box">Toilet Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_uses" name="toilet_uses" min="0" value="<?php echo isset($_POST['toilet_uses']) ? htmlspecialchars($_POST['toilet_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_flow" class="label-box">Toilet Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_flow" name="toilet_flow" step="0.1" min="0" value="<?php echo isset($_POST['toilet_flow']) ? htmlspecialchars($_POST['toilet_flow']) : ''; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower_uses']) && 
                        isset($_POST['shower_flow']) &&
                        isset($_POST['faucet_uses']) &&
                        isset($_POST['faucet_flow']) &&
                        isset($_POST['toilet_uses']) &&
                        isset($_POST['toilet_flow'])) {
                        
                        // Get input values
                        $shower_uses = floatval($_POST['shower_uses']);
                        $shower_flow = floatval($_POST['shower_flow']);
                        $faucet_uses = floatval($_POST['faucet_uses']);
                        $faucet_flow = floatval($_POST['faucet_flow']);
                        $toilet_uses = floatval($_POST['toilet_uses']);
                        $toilet_flow = floatval($_POST['toilet_flow']);

                        if ($shower_uses >= 0 && $shower_flow >= 0 && 
                            $faucet_uses >= 0 && $faucet_flow >= 0 && 
                            $toilet_uses >= 0 && $toilet_flow >= 0) {
                            
                            // Calculate total water usage
                            $usage = ($shower_uses * $shower_flow) + 
                                    ($faucet_uses * $faucet_flow) + 
                                    ($toilet_uses * $toilet_flow);
                            $usage = round($usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Household Water Use Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Usage Monitoring</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Household Water Use Calculation?</h3>
                <p>
Household water use calculation estimates daily water consumption by summing the products of usage frequency and flow rates for various water fixtures in a home. This helps in understanding water consumption patterns and identifying opportunities for conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water usage formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Usage} = \sum(\text{Daily Uses} \times \text{Flow Rates}) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Daily Uses} \) — Number of times a fixture is used per day</li>
                        <li>\( \text{Flow Rates} \) — Water consumption per use in liters</li>
                        <li>\( \sum \) — Summation of all fixture water uses</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation accounts for different water fixtures (shower, faucet, toilet) with their respective usage frequencies and flow rates to estimate total daily water consumption.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Usage Monitoring</h3>
                <p>
                    <strong>Details:</strong> Monitoring household water usage is essential for conservation efforts, reducing utility bills, and minimizing environmental impact. It helps identify high-consumption fixtures and opportunities for efficiency improvements.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of daily uses and flow rate for each water fixture. Use average values if exact measurements are not available. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical flow rate for a shower?</strong><br>
                    A: Standard showerheads have flow rates of 7.5-9.5 L/min, but low-flow models can use as little as 5.5 L/min.
                </p>
                <p>
                    <strong>Q2: How can I reduce my household water usage?</strong><br>
                    A: Install low-flow fixtures, fix leaks promptly, take shorter showers, and only run full loads in dishwashers and washing machines.
                </p>
                <p>
                    <strong>Q3: What is the average daily water usage per person?</strong><br>
                    A: This varies by region, but typically ranges from 150-300 liters per person per day in developed countries.
                </p>
                <p>
                    <strong>Q4: Should outdoor water use be included?</strong><br>
                    A: This calculator focuses on indoor water use. For a complete picture, consider adding outdoor uses like gardening and car washing separately.
                </p>
                <p>
                    <strong>Q5: How accurate are these estimates?</strong><br>
                    A: Accuracy depends on how precisely you measure your usage patterns. For best results, track your actual usage over several days.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Household Water Use Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
