
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Household Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Household Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Equation:
                </p>
<div class="formula-container">
    \[ WF (gal) = Direct\ Use (gal) + Virtual\ Water (gal) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct_use" class="label-box">Direct Use (gallons):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct_use" name="direct_use" step="0.01" min="0" value="<?php echo isset($_POST['direct_use']) ? htmlspecialchars($_POST['direct_use']) : ''; ?>" required>
                                <span class="calc-input">gallons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water" class="label-box">Virtual Water (gallons):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water" name="virtual_water" step="0.01" min="0" value="<?php echo isset($_POST['virtual_water']) ? htmlspecialchars($_POST['virtual_water']) : ''; ?>" required>
                                <span class="calc-input">gallons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct_use']) && 
                        isset($_POST['virtual_water'])) {
                        
                        // Get input values
                        $direct_use = floatval($_POST['direct_use']);
                        $virtual_water = floatval($_POST['virtual_water']);

                        if ($direct_use >= 0 && $virtual_water >= 0) {
                            // Calculate Water Footprint
                            $water_footprint = $direct_use + $virtual_water;
                            $water_footprint = round($water_footprint, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water_footprint) ? htmlspecialchars($water_footprint) . " gallons" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Footprint?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Footprint?</h3>
                <p>
Water Footprint measures the total volume of freshwater used directly and indirectly by a household. It includes both direct water consumption (from taps) and virtual water (embedded in products and services).
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the Water Footprint equation:
                </p>
                <div class="formula-2-container">
                    \[ WF (gal) = Direct\ Use (gal) + Virtual\ Water (gal) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Direct\ Use \) — Water directly consumed from household sources (gallons)</li>
                        <li>\( Virtual\ Water \) — Water embedded in products and services consumed (gallons)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This equation provides a comprehensive measure of a household's water consumption by accounting for both visible and hidden water usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding your water footprint helps identify water conservation opportunities, promotes sustainable water use, and contributes to global water resource management.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter direct water use and virtual water estimates in gallons. Both values must be non-negative numbers. For accurate results, use water bills for direct use and water footprint databases for virtual water estimates.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is included in direct water use?</strong><br>
                    A: Direct water use includes all water directly consumed from taps, showers, toilets, and outdoor uses like gardening and car washing.
                </p>
                <p>
                    <strong>Q2: How is virtual water calculated?</strong><br>
                    A: Virtual water is estimated based on the water required to produce goods and services, including food, clothing, and energy. Specialized databases provide average virtual water values for various products.
                </p>
                <p>
                    <strong>Q3: What is a typical household water footprint?</strong><br>
                    A: Water footprints vary significantly by location, lifestyle, and consumption patterns. The average US household has a water footprint of about 100,000 gallons per month when including virtual water.
                </p>
                <p>
                    <strong>Q4: How can I reduce my water footprint?</strong><br>
                    A: Reduce direct use through water-efficient appliances and fix leaks. Reduce virtual water by choosing products with lower water footprints and reducing consumption of water-intensive goods.
                </p>
                <p>
                    <strong>Q5: Why is virtual water important?</strong><br>
                    A: Virtual water often constitutes the largest portion of a household's water footprint. Understanding it helps make informed choices about consumption patterns that impact global water resources.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Household Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
