
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>How To Calculate Water Consumption In A Building</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>How To Calculate Water Consumption In A Building</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Consumption Formula:
                </p>
<div class="formula-container">
    \[ Consumption = Occupants \times Per\ Capita\ Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="occupants" class="label-box">Occupants:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="occupants" name="occupants" min="0" value="<?php echo isset($_POST['occupants']) ? htmlspecialchars($_POST['occupants']) : ''; ?>" required>
                                <span class="calc-input">people</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="per_capita_rate" class="label-box">Per Capita Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="per_capita_rate" name="per_capita_rate" step="0.01" min="0" value="<?php echo isset($_POST['per_capita_rate']) ? htmlspecialchars($_POST['per_capita_rate']) : ''; ?>" required>
                                <span class="calc-input">L/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['occupants']) && 
                        isset($_POST['per_capita_rate'])) {
                        
                        // Get input values
                        $occupants = intval($_POST['occupants']);
                        $per_capita_rate = floatval($_POST['per_capita_rate']);

                        if ($occupants > 0 && $per_capita_rate > 0) {
                            // Calculate water consumption
                            $consumption = $occupants * $per_capita_rate;
                            $consumption = round($consumption, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($consumption) ? htmlspecialchars($consumption) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Consumption Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Consumption Estimation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Consumption Calculation?</h3>
                <p>
Water consumption calculation estimates the daily water usage in a building based on the number of occupants and their average water usage rate. This helps in planning water supply systems, conservation efforts, and utility management.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water consumption formula:
                </p>
                <div class="formula-2-container">
                    \[ Consumption = Occupants \times Per\ Capita\ Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Occupants \) — Number of people in the building</li>
                        <li>\( Per\ Capita\ Rate \) — Average water usage per person per day (L/person/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation multiplies the number of occupants by the average daily water consumption rate per person to estimate total building water usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Consumption Estimation</h3>
                <p>
                    <strong>Details:</strong> Accurate water consumption estimation is crucial for designing water supply systems, planning conservation measures, budgeting for water costs, and ensuring sustainable water management in buildings.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of occupants and the per capita water usage rate. Typical per capita rates range from 80-150 L/person/day for residential buildings, but may vary based on building type and local usage patterns.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical per capita water usage rate?</strong><br>
                    A: Residential buildings typically use 80-150 liters per person per day, but this can vary based on factors like climate, building type, and water efficiency measures.
                </p>
                <p>
                    <strong>Q2: How does building type affect water consumption?</strong><br>
                    A: Commercial buildings, hospitals, schools, and industrial facilities have different water usage patterns than residential buildings, often requiring specialized calculations.
                </p>
                <p>
                    <strong>Q3: Should seasonal variations be considered?</strong><br>
                    A: Yes, water consumption often increases in summer months due to outdoor water use, gardening, and cooling systems.
                </p>
                <p>
                    <strong>Q4: How can water consumption be reduced?</strong><br>
                    A: Installing water-efficient fixtures, fixing leaks, implementing water recycling systems, and promoting water conservation practices can significantly reduce consumption.
                </p>
                <p>
                    <strong>Q5: Are there standards for water consumption calculation?</strong><br>
                    A: Various national and international standards provide guidelines for water consumption estimation, such as those from ASHRAE, IPC, and local building codes.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                How To Calculate Water Consumption In A Building© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
