
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>How To Calculate Water Footprint</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>How To Calculate Water Footprint</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Formula:
                </p>
<div class="formula-container">
    \[ WF (l) = Direct Use (l) + Virtual Water (l) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct_use" class="label-box">Direct Use (liters):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct_use" name="direct_use" step="0.01" min="0" value="<?php echo isset($_POST['direct_use']) ? htmlspecialchars($_POST['direct_use']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water" class="label-box">Virtual Water (liters):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water" name="virtual_water" step="0.01" min="0" value="<?php echo isset($_POST['virtual_water']) ? htmlspecialchars($_POST['virtual_water']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct_use']) && 
                        isset($_POST['virtual_water'])) {
                        
                        // Get input values
                        $direct_use = floatval($_POST['direct_use']);
                        $virtual_water = floatval($_POST['virtual_water']);

                        if ($direct_use >= 0 && $virtual_water >= 0) {
                            // Calculate water footprint
                            $water_footprint = $direct_use + $virtual_water;
                            $water_footprint = round($water_footprint, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water_footprint) ? htmlspecialchars($water_footprint) . " liters" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Footprint?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Footprint?</h3>
                <p>
Water footprint measures the total volume of freshwater used to produce the goods and services consumed by an individual, community, or business. It includes both direct water use and virtual water embedded in products.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water footprint formula:
                </p>
                <div class="formula-2-container">
                    \[ WF (l) = Direct Use (l) + Virtual Water (l) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Direct Use \) — Water consumed directly by an individual or organization (liters)</li>
                        <li>\( Virtual Water \) — Water embedded in the production of goods and services (liters)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation accounts for both visible water consumption and the hidden water used throughout production chains.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding water footprint helps in sustainable water management, identifying water-intensive processes, and making informed decisions about consumption patterns and production methods.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter direct water use in liters and virtual water content in liters. Both values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the difference between direct use and virtual water?</strong><br>
                    A: Direct use refers to water consumed directly (drinking, bathing, etc.), while virtual water is the water used in the production of goods and services you consume.
                </p>
                <p>
                    <strong>Q2: What are typical water footprint values?</strong><br>
                    A: Water footprints vary greatly by region and lifestyle. The global average is about 1,385 m³ per person per year, but this varies significantly between countries.
                </p>
                <p>
                    <strong>Q3: How can I reduce my water footprint?</strong><br>
                    A: Reduce meat consumption, choose water-efficient products, fix leaks, and be mindful of water-intensive activities and products.
                </p>
                <p>
                    <strong>Q4: Why is virtual water important?</strong><br>
                    A: Virtual water accounts for the majority of most people's water footprint and represents water used in other regions through trade.
                </p>
                <p>
                    <strong>Q5: Are there different types of water footprints?</strong><br>
                    A: Yes, water footprints are typically categorized into blue water (surface and groundwater), green water (rainwater), and gray water (polluted water).
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                How To Calculate Water Footprint© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
