
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Indirect Water Heater Sizing Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Indirect Water Heater Sizing Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Indirect Water Heater Sizing Formula:
                </p>
<div class="formula-container">
    \[ \text{size (gal)} = \frac{\text{coil\_output (BTU/h)} \times \text{time (h)}}{\Delta T (\text{°F})} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="coil_output" class="label-box">Coil Output:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="coil_output" name="coil_output" step="0.0001" min="0" value="<?php echo isset($_POST['coil_output']) ? htmlspecialchars($_POST['coil_output']) : ''; ?>" required>
                                <span class="calc-input">BTU/h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time" class="label-box">Time:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time" name="time" step="0.0001" min="0" value="<?php echo isset($_POST['time']) ? htmlspecialchars($_POST['time']) : ''; ?>" required>
                                <span class="calc-input">hours</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="delta_t" class="label-box">Temperature Difference (ΔT):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="delta_t" name="delta_t" step="0.0001" min="0" value="<?php echo isset($_POST['delta_t']) ? htmlspecialchars($_POST['delta_t']) : ''; ?>" required>
                                <span class="calc-input">°F</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['coil_output']) && 
                        isset($_POST['time']) &&
                        isset($_POST['delta_t'])) {
                        
                        // Get input values
                        $coil_output = floatval($_POST['coil_output']);
                        $time = floatval($_POST['time']);
                        $delta_t = floatval($_POST['delta_t']);

                        if ($coil_output > 0 && $time > 0 && $delta_t > 0) {
                            // Calculate water heater size
                            $size = ($coil_output * $time) / $delta_t;
                            $size = round($size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Heater Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " gallons" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Indirect Water Heater Sizing?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Indirect Water Heater Sizing?</h3>
                <p>
Indirect water heater sizing calculates the appropriate tank size needed based on the heating coil output, desired recovery time, and temperature difference. Proper sizing ensures efficient hot water delivery while minimizing energy consumption.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the indirect water heater sizing formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{size (gal)} = \frac{\text{coil\_output (BTU/h)} \times \text{time (h)}}{\Delta T (\text{°F})} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{coil\_output} \) — Heating coil output capacity in BTU per hour</li>
                        <li>\( \text{time} \) — Desired recovery time in hours</li>
                        <li>\( \Delta T \) — Temperature difference between incoming cold water and desired hot water temperature in °F</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the required tank size by determining how much water can be heated to the desired temperature within the specified time period using the available heating capacity.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Sizing</h3>
                <p>
                    <strong>Details:</strong> Proper water heater sizing is crucial for energy efficiency, adequate hot water supply, and system longevity. Oversized units waste energy, while undersized units cannot meet hot water demands.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter coil output in BTU/h, recovery time in hours, and temperature difference in °F. All values must be positive numbers. Typical ΔT values range from 70-100°F depending on your climate and desired water temperature.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical coil output for residential systems?</strong><br>
                    A: Residential systems typically range from 30,000 to 150,000 BTU/h depending on the boiler size and system design.
                </p>
                <p>
                    <strong>Q2: How long should the recovery time be?</strong><br>
                    A: Typical recovery times range from 0.5 to 2 hours for most residential applications. Shorter times require larger heating capacity.
                </p>
                <p>
                    <strong>Q3: What ΔT value should I use?</strong><br>
                    A: Standard calculation uses 70°F ΔT (from 50°F incoming to 120°F output). Adjust based on your local water temperature and desired output temperature.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for commercial systems?</strong><br>
                    A: Yes, but commercial systems may require additional factors such as peak demand calculations and multiple tank configurations.
                </p>
                <p>
                    <strong>Q5: What if I have multiple hot water fixtures?</strong><br>
                    A: For systems with multiple simultaneous fixtures, you may need to increase the tank size or consider a larger heating capacity to maintain adequate supply.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Indirect Water Heater Sizing Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
