
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Landscape Water Budget Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Landscape Water Budget Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Landscape Water Budget Equation:
                </p>
<div class="formula-container">
    \[ Budget = ET \times Area \times 0.62 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="et" class="label-box">Evapotranspiration (ET):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="et" name="et" step="0.0001" min="0" value="<?php echo isset($_POST['et']) ? htmlspecialchars($_POST['et']) : ''; ?>" required>
                                <span class="calc-input">in</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">sq ft</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['et']) && 
                        isset($_POST['area'])) {
                        
                        // Get input values
                        $et = floatval($_POST['et']);
                        $area = floatval($_POST['area']);

                        if ($et > 0 && $area > 0) {
                            // Calculate water budget
                            $budget = $et * $area * 0.62;
                            $budget = round($budget, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Budget:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($budget) ? htmlspecialchars($budget) . " gal" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Landscape Water Budget?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Budget Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Landscape Water Budget?</h3>
                <p>
The Landscape Water Budget calculates the estimated water requirement for maintaining healthy landscape vegetation based on evapotranspiration rates and area size. It helps in efficient water management and conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water budget equation:
                </p>
                <div class="formula-2-container">
                    \[ Budget = ET \times Area \times 0.62 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( ET \) — Evapotranspiration rate (inches)</li>
                        <li>\( Area \) — Landscape area (square feet)</li>
                        <li>\( 0.62 \) — Conversion factor to gallons</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the water requirement by multiplying the evapotranspiration rate with the landscape area and converting to gallons using the standard conversion factor.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Budget Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water budget calculation is essential for sustainable landscape management, water conservation, efficient irrigation planning, and compliance with water usage regulations.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter evapotranspiration rate in inches and landscape area in square feet. All values must be valid (ET > 0, area > 0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is evapotranspiration (ET)?</strong><br>
                    A: ET is the combined process of water evaporation from soil and transpiration from plants, representing the total water loss from the landscape.
                </p>
                <p>
                    <strong>Q2: Why is the 0.62 conversion factor used?</strong><br>
                    A: The factor 0.62 converts inches of water over square feet to gallons, as one inch of water over one square foot equals approximately 0.62 gallons.
                </p>
                <p>
                    <strong>Q3: How often should water budget be calculated?</strong><br>
                    A: Water budget should be calculated seasonally as ET rates change with weather conditions, or whenever landscape modifications occur.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this calculation?</strong><br>
                    A: This provides an estimate and may need adjustment for specific plant types, soil conditions, and microclimates within the landscape.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for irrigation scheduling?</strong><br>
                    A: Yes, the calculated water budget helps determine appropriate irrigation amounts and frequencies for efficient water use.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Landscape Water Budget Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>