
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Landscape Water Requirement Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Landscape Water Requirement Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Landscape Water Requirement Equation:
                </p>
<div class="formula-container">
    \[ requirement = \frac{ET_{land} \times area_{land} \times plant\_factor}{eff_{land}} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="et_land" class="label-box">Evapotranspiration (ET_land):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="et_land" name="et_land" step="0.0001" min="0" value="<?php echo isset($_POST['et_land']) ? htmlspecialchars($_POST['et_land']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="area_land" class="label-box">Area (area_land):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area_land" name="area_land" step="0.0001" min="0" value="<?php echo isset($_POST['area_land']) ? htmlspecialchars($_POST['area_land']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="plant_factor" class="label-box">Plant Factor (plant_factor):</label>
                            <input class="calc-input" type="number" id="plant_factor" name="plant_factor" step="0.0001" min="0" value="<?php echo isset($_POST['plant_factor']) ? htmlspecialchars($_POST['plant_factor']) : ''; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="eff_land" class="label-box">Efficiency (eff_land):</label>
                            <input class="calc-input" type="number" id="eff_land" name="eff_land" step="0.0001" min="0" value="<?php echo isset($_POST['eff_land']) ? htmlspecialchars($_POST['eff_land']) : ''; ?>" required>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['et_land']) && 
                        isset($_POST['area_land']) &&
                        isset($_POST['plant_factor']) &&
                        isset($_POST['eff_land'])) {
                        
                        // Get input values
                        $et_land = floatval($_POST['et_land']);
                        $area_land = floatval($_POST['area_land']);
                        $plant_factor = floatval($_POST['plant_factor']);
                        $eff_land = floatval($_POST['eff_land']);

                        if ($et_land > 0 && $area_land > 0 && $plant_factor > 0 && $eff_land > 0) {
                            // Calculate water requirement
                            $requirement = ($et_land * $area_land * $plant_factor) / $eff_land;
                            $requirement = round($requirement, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Requirement:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($requirement) ? htmlspecialchars($requirement) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Landscape Water Requirement?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Requirement Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Landscape Water Requirement?</h3>
                <p>
Landscape water requirement calculation determines the amount of water needed to maintain healthy vegetation in a given area, taking into account evapotranspiration rates, plant types, and irrigation efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water requirement equation:
                </p>
                <div class="formula-2-container">
                    \[ requirement = \frac{ET_{land} \times area_{land} \times plant\_factor}{eff_{land}} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( ET_{land} \) — Evapotranspiration rate (mm)</li>
                        <li>\( area_{land} \) — Landscape area (m²)</li>
                        <li>\( plant\_factor \) — Plant factor (dimensionless)</li>
                        <li>\( eff_{land} \) — Irrigation efficiency (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the actual water requirement by adjusting for plant water needs and irrigation system efficiency.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Requirement Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water requirement calculation is essential for efficient water management, sustainable landscaping, preventing over/under-watering, and conserving water resources.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter evapotranspiration in mm, area in square meters, plant factor (typically 0.5-1.2), and irrigation efficiency (typically 0.6-0.9). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is evapotranspiration (ET)?</strong><br>
                    A: ET is the combined process of water evaporation from soil and transpiration from plants, representing the water loss from the landscape.
                </p>
                <p>
                    <strong>Q2: How do I determine the plant factor?</strong><br>
                    A: Plant factor varies by vegetation type: low-water plants (0.3-0.5), moderate-water plants (0.6-0.8), high-water plants (0.9-1.2).
                </p>
                <p>
                    <strong>Q3: What is typical irrigation efficiency?</strong><br>
                    A: Efficiency ranges from 0.6 for sprinklers to 0.9 for drip irrigation systems, depending on system type and maintenance.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for agricultural purposes?</strong><br>
                    A: While the basic principle is similar, agricultural water requirements may need additional factors considered for specific crops.
                </p>
                <p>
                    <strong>Q5: How often should water requirements be recalculated?</strong><br>
                    A: Water requirements should be recalculated seasonally as ET rates change with weather conditions and plant growth stages.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Landscape Water Requirement Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>