
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Part G Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Part G Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Part G Water Equation:
                </p>
<div class="formula-container">
    \[ Total = \sum(Fixture\ Consumption) + 5 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixture_consumption" class="label-box">Fixture Consumption (l/person/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixture_consumption" name="fixture_consumption" step="0.01" min="0" value="<?php echo isset($_POST['fixture_consumption']) ? htmlspecialchars($_POST['fixture_consumption']) : ''; ?>" required>
                                <span class="calc-input">l/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['fixture_consumption'])) {
                        
                        // Get input values
                        $fixture_consumption = floatval($_POST['fixture_consumption']);

                        if ($fixture_consumption >= 0) {
                            // Calculate total water consumption
                            $total = $fixture_consumption + 5;
                            $total = round($total, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total) ? htmlspecialchars($total) . " l/person/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Part G Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Consumption Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Part G Water Calculation?</h3>
                <p>
The Part G water calculation determines total water consumption by summing fixture consumption and adding a standard 5 l/person/day allowance. This calculation is essential for plumbing system design and water usage planning.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Part G water equation:
                </p>
                <div class="formula-2-container">
                    \[ Total = \sum(Fixture\ Consumption) + 5 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Fixture\ Consumption \) — Water usage from fixtures (l/person/day)</li>
                        <li>\( 5 \) — Standard additional allowance (l/person/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation accounts for both measured fixture consumption and a standard additional allowance for unmeasured water usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Consumption Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water consumption estimation is crucial for plumbing system design, water supply planning, and ensuring adequate water availability for building occupants.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter fixture consumption in l/person/day. The value must be a valid non-negative number.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What does the 5 l/person/day represent?</strong><br>
                    A: This represents a standard allowance for unmeasured water consumption, including potential leaks, system losses, and minor additional uses.
                </p>
                <p>
                    <strong>Q2: How is fixture consumption typically measured?</strong><br>
                    A: Fixture consumption is calculated based on the type and number of water fixtures, their flow rates, and estimated usage patterns.
                </p>
                <p>
                    <strong>Q3: Are there different standards for different building types?</strong><br>
                    A: Yes, water consumption standards may vary based on building type (residential, commercial, industrial) and local regulations.
                </p>
                <p>
                    <strong>Q4: Why is this calculation important for plumbing design?</strong><br>
                    A: It ensures that plumbing systems are properly sized to meet demand, preventing issues like low water pressure or inadequate supply.
                </p>
                <p>
                    <strong>Q5: Can this calculation be used for water conservation planning?</strong><br>
                    A: Yes, understanding total water consumption helps in designing efficient systems and implementing water conservation measures.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Part G Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
