
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Part G Water Efficiency Calculations</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Part G Water Efficiency Calculations</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Efficiency Formula:
                </p>
<div class="formula-container">
    \[ total = \sum(fixture\_consumption) + 5 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixture_consumption" class="label-box">Fixture Consumption (l/person/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixture_consumption" name="fixture_consumption" step="0.01" min="0" value="<?php echo isset($_POST['fixture_consumption']) ? htmlspecialchars($_POST['fixture_consumption']) : ''; ?>" required>
                                <span class="calc-input">l/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['fixture_consumption'])) {
                        
                        // Get input values
                        $fixture_consumption = floatval($_POST['fixture_consumption']);

                        if ($fixture_consumption >= 0) {
                            // Calculate total water efficiency
                            $total = $fixture_consumption + 5;
                            $total = round($total, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Efficiency (l/person/day):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total) ? htmlspecialchars($total) . " l/person/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Part G Water Efficiency?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Efficiency Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Part G Water Efficiency?</h3>
                <p>
Part G Water Efficiency refers to building regulations that set standards for water usage in properties. It ensures efficient water use through calculated consumption rates for various fixtures.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water efficiency formula:
                </p>
                <div class="formula-2-container">
                    \[ total = \sum(fixture\_consumption) + 5 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( fixture\_consumption \) — Total water consumption from all fixtures (l/person/day)</li>
                        <li>\( 5 \) — Standard additional allowance (l/person/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water efficiency by summing fixture consumption and adding a standard 5 l/person/day allowance.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Efficiency Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water efficiency calculation is crucial for compliance with building regulations, sustainable water management, and reducing environmental impact.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the total fixture consumption in liters per person per day. The value must be valid (≥0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What does Part G cover?</strong><br>
                    A: Part G of building regulations covers sanitation, hot water safety, and water efficiency standards in England and Wales.
                </p>
                <p>
                    <strong>Q2: What is considered good water efficiency?</strong><br>
                    A: Typically, properties should aim for ≤125 l/person/day, with excellent efficiency being ≤110 l/person/day.
                </p>
                <p>
                    <strong>Q3: What fixtures are included in the calculation?</strong><br>
                    A: Toilets, showers, baths, taps, and any other water-consuming fixtures in the property.
                </p>
                <p>
                    <strong>Q4: Why is there a +5 allowance?</strong><br>
                    A: The +5 l/person/day accounts for external water use and potential variations in consumption patterns.
                </p>
                <p>
                    <strong>Q5: Is this calculation mandatory?</strong><br>
                    A: Yes, for new builds and major renovations in England and Wales to comply with Part G building regulations.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Part G Water Efficiency Calculations© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
