
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Parts Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Parts Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Parts Calculation Formula:
                </p>
<div class="formula-container">
    \[ Parts = \frac{Total\ Volume}{Part\ Size} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="total_volume" class="label-box">Total Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="total_volume" name="total_volume" step="0.01" min="0" value="<?php echo isset($_POST['total_volume']) ? htmlspecialchars($_POST['total_volume']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="part_size" class="label-box">Part Size:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="part_size" name="part_size" step="0.01" min="0" value="<?php echo isset($_POST['part_size']) ? htmlspecialchars($_POST['part_size']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['total_volume']) && 
                        isset($_POST['part_size'])) {
                        
                        // Get input values
                        $total_volume = floatval($_POST['total_volume']);
                        $part_size = floatval($_POST['part_size']);

                        if ($total_volume > 0 && $part_size > 0) {
                            // Calculate parts
                            $parts = $total_volume / $part_size;
                            $parts = round($parts, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Number of Parts:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($parts) ? htmlspecialchars($parts) . " parts" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Parts Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Parts Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Parts Calculation?</h3>
                <p>
Parts calculation is a simple mathematical operation that divides a total volume into equal parts of a specified size. This is commonly used in various applications such as chemistry, cooking, and manufacturing.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the parts formula:
                </p>
                <div class="formula-2-container">
                    \[ Parts = \frac{Total\ Volume}{Part\ Size} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Total\ Volume \) — The total volume of liquid (L)</li>
                        <li>\( Part\ Size \) — The size of each individual part (L)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates how many equal parts of a specified size can be obtained from a total volume.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Parts Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate parts calculation is essential for precise measurements in various fields including laboratory work, recipe preparation, and industrial processes where consistent portioning is required.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the total volume in liters and the desired part size in liters. Both values must be positive numbers greater than zero.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Can I use different units of measurement?</strong><br>
                    A: The calculator uses liters as the standard unit. If you have measurements in different units, convert them to liters first for accurate results.
                </p>
                <p>
                    <strong>Q2: What if the part size is larger than the total volume?</strong><br>
                    A: The result will be a decimal value less than 1, indicating that you have a fraction of one complete part.
                </p>
                <p>
                    <strong>Q3: Can this calculator handle decimal values?</strong><br>
                    A: Yes, the calculator accepts decimal values for both total volume and part size, allowing for precise calculations.
                </p>
                <p>
                    <strong>Q4: Is there a limit to the number of parts that can be calculated?</strong><br>
                    A: The calculator can handle any positive numbers, but extremely large values may be limited by your browser's computational capabilities.
                </p>
                <p>
                    <strong>Q5: Can I use this for non-liquid measurements?</strong><br>
                    A: While designed for liquid volumes, the calculation works for any consistent units of measurement where you need to divide a total quantity into equal parts.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Parts Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
