
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rainwater Tank Calculation Formula</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Rainwater Tank Calculation Formula</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Rainwater Tank Formula:
                </p>
<div class="formula-container">
    \[ V (l) = Rainfall (mm) \times Area (m²) \times Runoff\ coefficient \times \frac{1000}{1000} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.01" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">millimeters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.01" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">square meters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coefficient" class="label-box">Runoff Coefficient:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="coefficient" name="coefficient" step="0.01" min="0" max="1" value="<?php echo isset($_POST['coefficient']) ? htmlspecialchars($_POST['coefficient']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['rainfall']) && 
                        isset($_POST['area']) &&
                        isset($_POST['coefficient'])) {
                        
                        // Get input values
                        $rainfall = floatval($_POST['rainfall']);
                        $area = floatval($_POST['area']);
                        $coefficient = floatval($_POST['coefficient']);

                        if ($rainfall > 0 && $area > 0 && $coefficient > 0) {
                            // Calculate rainwater tank volume
                            $volume = $rainfall * $area * $coefficient;
                            $volume = round($volume, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Rainwater Tank Volume:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($volume) ? htmlspecialchars($volume) . " liters" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Rainwater Tank Calculation Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Rainwater Harvesting</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Rainwater Tank Calculation Formula?</h3>
                <p>
The Rainwater Tank Calculation Formula estimates the volume of rainwater that can be collected from a catchment area based on rainfall amount and runoff efficiency. This helps in determining the appropriate tank size for rainwater harvesting systems.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the rainwater tank formula:
                </p>
                <div class="formula-2-container">
                    \[ V (l) = Rainfall (mm) \times Area (m²) \times Runoff\ coefficient \times \frac{1000}{1000} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Rainfall \) — Precipitation amount in millimeters</li>
                        <li>\( Area \) — Catchment area in square meters</li>
                        <li>\( Runoff\ coefficient \) — Efficiency factor (0-1) representing the portion of rainfall that becomes runoff</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the volume of collectible rainwater by multiplying rainfall depth by catchment area and adjusting for runoff efficiency.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Rainwater Harvesting</h3>
                <p>
                    <strong>Details:</strong> Proper rainwater tank sizing is crucial for sustainable water management, reducing municipal water consumption, and ensuring adequate water supply during dry periods.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter rainfall in millimeters, catchment area in square meters, and runoff coefficient (typically 0.6-0.9 for roof surfaces). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical runoff coefficient for roofs?</strong><br>
                    A: For most roof surfaces, runoff coefficients range from 0.6 to 0.9, depending on material and slope.
                </p>
                <p>
                    <strong>Q2: How accurate is this calculation?</strong><br>
                    A: The calculation provides a theoretical maximum. Actual collection may vary due to evaporation, spillage, and first-flush diversion.
                </p>
                <p>
                    <strong>Q3: Should I consider rainfall patterns?</strong><br>
                    A: Yes, for optimal tank sizing, consider seasonal variations and drought periods in your region.
                </p>
                <p>
                    <strong>Q4: What about water quality considerations?</strong><br>
                    A: Roof-collected rainwater may contain contaminants. Proper filtration and treatment are recommended for potable uses.
                </p>
                <p>
                    <strong>Q5: How does tank size relate to water usage?</strong><br>
                    A: Tank size should be balanced between catchment potential and consumption needs to avoid overflow or shortage.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Rainwater Tank Calculation Formula© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>