
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rainwater Tank Size Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Rainwater Tank Size Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Rainwater Tank Size Formula:
                </p>
<div class="formula-container">
    \[ Size = Roof Area \times Rainfall \times Efficiency \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="roof_area" class="label-box">Roof Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="roof_area" name="roof_area" step="0.01" min="0" value="<?php echo isset($_POST['roof_area']) ? htmlspecialchars($_POST['roof_area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.1" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="eff_rain_tank" class="label-box">Efficiency:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="eff_rain_tank" name="eff_rain_tank" step="0.01" min="0" max="1" value="<?php echo isset($_POST['eff_rain_tank']) ? htmlspecialchars($_POST['eff_rain_tank']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['roof_area']) && 
                        isset($_POST['rainfall']) &&
                        isset($_POST['eff_rain_tank'])) {
                        
                        // Get input values
                        $roof_area = floatval($_POST['roof_area']);
                        $rainfall = floatval($_POST['rainfall']);
                        $eff_rain_tank = floatval($_POST['eff_rain_tank']);

                        if ($roof_area > 0 && $rainfall > 0 && $eff_rain_tank > 0) {
                            // Calculate rainwater tank size
                            $size = $roof_area * $rainfall * $eff_rain_tank;
                            $size = round($size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Rainwater Tank Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Rainwater Tank Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Rainwater Harvesting</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Rainwater Tank Size Calculation?</h3>
                <p>
Rainwater tank size calculation determines the optimal storage capacity needed for rainwater harvesting systems. It helps in designing efficient water collection systems for residential, commercial, or agricultural use.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the rainwater tank size formula:
                </p>
                <div class="formula-2-container">
                    \[ Size = Roof Area \times Rainfall \times Efficiency \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Roof Area \) — Catchment area in square meters (m²)</li>
                        <li>\( Rainfall \) — Average rainfall in millimeters (mm)</li>
                        <li>\( Efficiency \) — Collection efficiency factor (dimensionless, typically 0.8-0.9)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the theoretical maximum rainwater collection volume based on catchment area and rainfall, adjusted for system efficiency losses.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Rainwater Harvesting</h3>
                <p>
                    <strong>Details:</strong> Proper rainwater tank sizing is crucial for sustainable water management, reducing municipal water consumption, and ensuring adequate water supply during dry periods.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter roof area in square meters, average rainfall in millimeters, and efficiency factor (typically 0.8-0.9). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical efficiency factor for rainwater collection?</strong><br>
                    A: Efficiency typically ranges from 0.8 to 0.9, accounting for evaporation, splash loss, and first flush diversion.
                </p>
                <p>
                    <strong>Q2: How do I measure roof area accurately?</strong><br>
                    A: Measure the horizontal projection of the roof area. For complex roofs, break into simple shapes and sum the areas.
                </p>
                <p>
                    <strong>Q3: What rainfall data should I use?</strong><br>
                    A: Use average annual rainfall data for your location from meteorological records, considering seasonal variations.
                </p>
                <p>
                    <strong>Q4: Should I consider water demand when sizing tanks?</strong><br>
                    A: Yes, tank size should also consider water usage patterns and dry period duration, not just collection potential.
                </p>
                <p>
                    <strong>Q5: Are there maintenance considerations for rainwater tanks?</strong><br>
                    A: Regular maintenance including gutter cleaning, first flush device maintenance, and tank inspection is essential for optimal performance.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Rainwater Tank Size Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
