
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rainwater Tank Size Calculator Australia</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Rainwater Tank Size Calculator Australia</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Rainwater Tank Size Formula:
                </p>
<div class="formula-container">
    \[ \text{Tank (l)} = \text{Annual rainfall (mm)} \times \text{Roof area (m²)} \times \text{Efficiency} / 1000 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Annual Rainfall:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.01" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">millimeters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="roof_area" class="label-box">Roof Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="roof_area" name="roof_area" step="0.01" min="0" value="<?php echo isset($_POST['roof_area']) ? htmlspecialchars($_POST['roof_area']) : ''; ?>" required>
                                <span class="calc-input">square meters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="efficiency" class="label-box">Efficiency:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="efficiency" name="efficiency" step="0.01" min="0" max="1" value="<?php echo isset($_POST['efficiency']) ? htmlspecialchars($_POST['efficiency']) : '0.85'; ?>" required>
                                <span class="calc-input">(0-1)</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['rainfall']) && 
                        isset($_POST['roof_area']) &&
                        isset($_POST['efficiency'])) {
                        
                        // Get input values
                        $rainfall = floatval($_POST['rainfall']);
                        $roof_area = floatval($_POST['roof_area']);
                        $efficiency = floatval($_POST['efficiency']);

                        if ($rainfall > 0 && $roof_area > 0 && $efficiency > 0) {
                            // Calculate tank size
                            $tank_size = $rainfall * $roof_area * $efficiency / 1000;
                            $tank_size = round($tank_size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Required Tank Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($tank_size) ? htmlspecialchars($tank_size) . " liters" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Rainwater Tank Sizing?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Tank Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Rainwater Tank Sizing?</h3>
                <p>
Rainwater tank sizing involves calculating the appropriate storage capacity needed to collect and store rainwater from your roof catchment area based on local rainfall patterns and usage requirements.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the rainwater tank sizing formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Tank (l)} = \text{Annual rainfall (mm)} \times \text{Roof area (m²)} \times \text{Efficiency} / 1000 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Annual rainfall} \) — Average annual rainfall in millimeters</li>
                        <li>\( \text{Roof area} \) — Total catchment area in square meters</li>
                        <li>\( \text{Efficiency} \) — Collection efficiency factor (typically 0.8-0.9)</li>
                        <li>\( 1000 \) — Conversion factor from liters to cubic meters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the theoretical maximum rainwater collection potential based on rainfall volume and roof catchment area, adjusted for system efficiency losses.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Tank Sizing</h3>
                <p>
                    <strong>Details:</strong> Correct tank sizing ensures adequate water supply during dry periods, prevents overflow during wet seasons, optimizes investment costs, and maximizes water conservation benefits.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter annual rainfall in millimeters, roof area in square meters, and efficiency factor (typically 0.85 for standard systems). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical efficiency factor for rainwater systems?</strong><br>
                    A: Most systems have an efficiency of 0.8-0.9, accounting for evaporation, first flush diversion, and system losses.
                </p>
                <p>
                    <strong>Q2: How do I find my local annual rainfall data?</strong><br>
                    A: Check the Bureau of Meteorology website or local council resources for rainfall data specific to your region.
                </p>
                <p>
                    <strong>Q3: Should I consider water usage patterns in tank sizing?</strong><br>
                    A: Yes, for optimal sizing, also consider your household water consumption patterns and the length of dry periods in your region.
                </p>
                <p>
                    <strong>Q4: What are common tank sizes available?</strong><br>
                    A: Common residential tank sizes range from 2,000 to 20,000 liters, with larger tanks available for commercial applications.
                </p>
                <p>
                    <strong>Q5: Are there rebates available for rainwater tanks in Australia?</strong><br>
                    A: Many local councils and state governments offer rebates and incentives for rainwater tank installation - check with your local authorities.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Rainwater Tank Size Calculator Australia© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>