
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rinnai Tankless Water Heater Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Rinnai Tankless Water Heater Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    GPM Calculation Formula:
                </p>
<div class="formula-container">
    \[ GPM = \sum (Fixture\ Flow\ Rates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower" class="label-box">Shower Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower" name="shower" step="0.1" min="0" value="<?php echo isset($_POST['shower']) ? htmlspecialchars($_POST['shower']) : ''; ?>" required>
                                <span class="calc-input">gpm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet" class="label-box">Faucet Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet" name="faucet" step="0.1" min="0" value="<?php echo isset($_POST['faucet']) ? htmlspecialchars($_POST['faucet']) : ''; ?>" required>
                                <span class="calc-input">gpm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dishwasher" class="label-box">Dishwasher Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dishwasher" name="dishwasher" step="0.1" min="0" value="<?php echo isset($_POST['dishwasher']) ? htmlspecialchars($_POST['dishwasher']) : ''; ?>" required>
                                <span class="calc-input">gpm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="washer" class="label-box">Washing Machine Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="washer" name="washer" step="0.1" min="0" value="<?php echo isset($_POST['washer']) ? htmlspecialchars($_POST['washer']) : ''; ?>" required>
                                <span class="calc-input">gpm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower']) && 
                        isset($_POST['faucet']) &&
                        isset($_POST['dishwasher']) &&
                        isset($_POST['washer'])) {
                        
                        // Get input values
                        $shower = floatval($_POST['shower']);
                        $faucet = floatval($_POST['faucet']);
                        $dishwasher = floatval($_POST['dishwasher']);
                        $washer = floatval($_POST['washer']);

                        if ($shower >= 0 && $faucet >= 0 && $dishwasher >= 0 && $washer >= 0) {
                            // Calculate total GPM
                            $gpm = $shower + $faucet + $dishwasher + $washer;
                            $gpm = round($gpm, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Required GPM:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($gpm) ? htmlspecialchars($gpm) . " gpm" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is GPM Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of GPM Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is GPM Calculation?</h3>
                <p>
GPM (Gallons Per Minute) calculation determines the total flow rate required for a Rinnai tankless water heater by summing the flow rates of all fixtures that may be used simultaneously.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ GPM = \sum (Fixture\ Flow\ Rates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Shower Flow Rate — Typical range: 1.5-2.5 gpm</li>
                        <li>Faucet Flow Rate — Typical range: 0.5-2.2 gpm</li>
                        <li>Dishwasher Flow Rate — Typical range: 1.0-2.5 gpm</li>
                        <li>Washing Machine Flow Rate — Typical range: 1.5-3.0 gpm</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculator sums the flow rates of all fixtures to determine the total GPM requirement for proper tankless water heater sizing.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of GPM Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate GPM calculation ensures your Rinnai tankless water heater is properly sized to meet your household's hot water demands, preventing insufficient hot water supply.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the flow rates for each fixture in gallons per minute (gpm). Use manufacturer specifications or standard values for accurate calculations.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is GPM important for tankless water heaters?</strong><br>
                    A: GPM determines the heating capacity needed. Undersized units won't provide enough hot water for simultaneous use.
                </p>
                <p>
                    <strong>Q2: What is a typical GPM requirement for a household?</strong><br>
                    A: Most households require 5-7 GPM, but this varies based on the number of bathrooms and appliances.
                </p>
                <p>
                    <strong>Q3: Can I reduce my GPM requirement?</strong><br>
                    A: Yes, by using low-flow fixtures and staggering hot water usage.
                </p>
                <p>
                    <strong>Q4: What temperature rise should I consider?</strong><br>
                    A: Most calculations assume a 70°F temperature rise, but this depends on your groundwater temperature.
                </p>
                <p>
                    <strong>Q5: Should I consult a professional for sizing?</strong><br>
                    A: Yes, professional consultation is recommended for accurate sizing, especially for larger homes.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Rinnai Tankless Water Heater Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
