
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Severn Trent Water Use Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Severn Trent Water Use Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Severn Trent Water Use Equation:
                </p>
<div class="formula-container">
    \[ \text{Usage (m³)} = \text{Daily use (l/day)} \times 0.001 \times \text{Days} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="daily_use" class="label-box">Daily use (liters per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="daily_use" name="daily_use" step="0.01" min="0" value="<?php echo isset($_POST['daily_use']) ? htmlspecialchars($_POST['daily_use']) : ''; ?>" required>
                                <span class="calc-input">l/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days" class="label-box">Days (dimensionless):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days" name="days" step="1" min="1" value="<?php echo isset($_POST['days']) ? htmlspecialchars($_POST['days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['daily_use']) && 
                        isset($_POST['days'])) {
                        
                        // Get input values
                        $daily_use = floatval($_POST['daily_use']);
                        $days = intval($_POST['days']);

                        if ($daily_use > 0 && $days > 0) {
                            // Calculate water usage
                            $usage = $daily_use * 0.001 * $days;
                            $usage = round($usage, 3);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage (cubic meters):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Severn Trent Water Use Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Severn Trent Water Use Calculator?</h3>
                <p>
The Severn Trent Water Use Calculator estimates water consumption in cubic meters for the Severn Trent region based on daily usage in liters and the number of days. It provides an accurate assessment of water consumption for billing and conservation purposes.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ \text{Usage (m³)} = \text{Daily use (l/day)} \times 0.001 \times \text{Days} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Daily use} \) — Daily water consumption in liters per day</li>
                        <li>\( \text{Days} \) — Number of days of water usage</li>
                        <li>\( 0.001 \) — Conversion factor from liters to cubic meters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation converts daily water usage from liters to cubic meters and multiplies by the number of days to calculate total consumption.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage calculation is crucial for understanding consumption patterns, managing water bills, and promoting water conservation in the Severn Trent region.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter daily water usage in liters per day and the number of days. All values must be valid (daily use > 0, days ≥ 1).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why convert liters to cubic meters?</strong><br>
                    A: Water utilities typically bill in cubic meters, so conversion helps understand actual consumption and costs.
                </p>
                <p>
                    <strong>Q2: What is considered average daily water usage?</strong><br>
                    A: Average daily usage varies, but typically ranges from 100-150 liters per person per day in the UK.
                </p>
                <p>
                    <strong>Q3: How accurate is this calculation?</strong><br>
                    A: The calculation provides a precise mathematical conversion, but actual usage may vary based on measurement accuracy.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for commercial properties?</strong><br>
                    A: Yes, the same calculation applies to both residential and commercial water usage in the Severn Trent region.
                </p>
                <p>
                    <strong>Q5: Does this account for seasonal variations?</strong><br>
                    A: No, this is a basic calculation. For more accurate seasonal analysis, daily usage data should reflect seasonal consumption patterns.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Severn Trent Water Use Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>