
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Specific Weight Of Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Specific Weight Of Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Specific Weight Formula:
                </p>
<div class="formula-container">
    \[ \gamma = \rho \times g \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="density" class="label-box">Density (ρ):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="density" name="density" step="0.0001" min="0" value="<?php echo isset($_POST['density']) ? htmlspecialchars($_POST['density']) : '1000'; ?>" required>
                                <span class="calc-input">kg/m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="gravity" class="label-box">Gravity (g):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="gravity" name="gravity" step="0.0001" min="0" value="<?php echo isset($_POST['gravity']) ? htmlspecialchars($_POST['gravity']) : '9.81'; ?>" required>
                                <span class="calc-input">m/s²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['density']) && 
                        isset($_POST['gravity'])) {
                        
                        // Get input values
                        $density = floatval($_POST['density']);
                        $gravity = floatval($_POST['gravity']);

                        if ($density > 0 && $gravity > 0) {
                            // Calculate specific weight
                            $specific_weight = $density * $gravity;
                            $specific_weight = round($specific_weight, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Specific Weight (γ):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($specific_weight) ? htmlspecialchars($specific_weight) . " N/m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Specific Weight of Water?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Specific Weight Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Specific Weight of Water?</h3>
                <p>
Specific weight (γ) is the weight per unit volume of a material. For water, it represents the force exerted by water's weight per cubic meter, calculated as the product of density (ρ) and gravitational acceleration (g).
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the specific weight formula:
                </p>
                <div class="formula-2-container">
                    \[ \gamma = \rho \times g \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \gamma \) — Specific weight (N/m³)</li>
                        <li>\( \rho \) — Density of water (kg/m³)</li>
                        <li>\( g \) — Gravitational acceleration (m/s²)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the weight force of water per unit volume, which is essential in fluid mechanics and hydraulic engineering applications.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Specific Weight Calculation</h3>
                <p>
                    <strong>Details:</strong> Specific weight is crucial for designing hydraulic structures, calculating buoyancy forces, determining fluid pressures, and analyzing fluid behavior in various engineering applications.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water density in kg/m³ (typically 1000 kg/m³ for pure water) and gravitational acceleration in m/s² (typically 9.81 m/s² on Earth). Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the typical specific weight of water?</strong><br>
                    A: For pure water at 4°C on Earth, the specific weight is approximately 9810 N/m³ (1000 kg/m³ × 9.81 m/s²).
                </p>
                <p>
                    <strong>Q2: How does temperature affect specific weight?</strong><br>
                    A: Temperature affects water density. Warmer water has lower density, resulting in slightly lower specific weight values.
                </p>
                <p>
                    <strong>Q3: What's the difference between specific weight and density?</strong><br>
                    A: Density is mass per unit volume (kg/m³), while specific weight is weight per unit volume (N/m³). Specific weight includes the gravitational component.
                </p>
                <p>
                    <strong>Q4: Does specific weight change with location?</strong><br>
                    A: Yes, since gravitational acceleration varies slightly with latitude and altitude, specific weight will also vary accordingly.
                </p>
                <p>
                    <strong>Q5: When is specific weight used in engineering?</strong><br>
                    A: Specific weight is used in hydraulic engineering, buoyancy calculations, pressure determination, and structural design involving fluids.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Specific Weight Of Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>