
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sprinkler Usage Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Sprinkler Usage Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Sprinkler Usage Formula:
                </p>
<div class="formula-container">
    \[ usage_{spr} = number_{spr} \times flow_{spr} \times time_{spr} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="number_spr" class="label-box">Number of Sprinklers:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="number_spr" name="number_spr" min="1" value="<?php echo isset($_POST['number_spr']) ? htmlspecialchars($_POST['number_spr']) : ''; ?>" required>
                                <span class="calc-input">number</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="flow_spr" class="label-box">Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="flow_spr" name="flow_spr" step="0.01" min="0" value="<?php echo isset($_POST['flow_spr']) ? htmlspecialchars($_POST['flow_spr']) : ''; ?>" required>
                                <span class="calc-input">L/min</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time_spr" class="label-box">Time:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time_spr" name="time_spr" step="0.01" min="0" value="<?php echo isset($_POST['time_spr']) ? htmlspecialchars($_POST['time_spr']) : ''; ?>" required>
                                <span class="calc-input">min</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['number_spr']) && 
                        isset($_POST['flow_spr']) &&
                        isset($_POST['time_spr'])) {
                        
                        // Get input values
                        $number_spr = floatval($_POST['number_spr']);
                        $flow_spr = floatval($_POST['flow_spr']);
                        $time_spr = floatval($_POST['time_spr']);

                        if ($number_spr > 0 && $flow_spr > 0 && $time_spr > 0) {
                            // Calculate sprinkler usage
                            $usage_spr = $number_spr * $flow_spr * $time_spr;
                            $usage_spr = round($usage_spr, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage_spr) ? htmlspecialchars($usage_spr) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Sprinkler Usage Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Sprinkler Usage Formula?</h3>
                <p>
The sprinkler usage formula calculates the total water consumption of a sprinkler system based on the number of sprinklers, their flow rate, and operating time. This helps in water conservation planning and irrigation management.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the sprinkler usage formula:
                </p>
                <div class="formula-2-container">
                    \[ usage_{spr} = number_{spr} \times flow_{spr} \times time_{spr} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( number_{spr} \) — Number of sprinklers</li>
                        <li>\( flow_{spr} \) — Flow rate per sprinkler (L/min)</li>
                        <li>\( time_{spr} \) — Operating time (minutes)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula multiplies the number of sprinklers by their individual flow rate and the total operating time to determine the overall water consumption.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Calculating sprinkler water usage is essential for efficient irrigation planning, water conservation efforts, cost estimation, and ensuring compliance with local water restrictions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of sprinklers, flow rate per sprinkler in liters per minute, and operating time in minutes. All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: How do I measure the flow rate of my sprinklers?</strong><br>
                    A: You can measure flow rate by timing how long it takes to fill a container of known volume, then converting to liters per minute.
                </p>
                <p>
                    <strong>Q2: Does this calculation account for different sprinkler types?</strong><br>
                    A: The calculation assumes all sprinklers have the same flow rate. For mixed systems, calculate each type separately and sum the results.
                </p>
                <p>
                    <strong>Q3: How accurate is this calculation for real-world usage?</strong><br>
                    A: This provides an estimate. Actual usage may vary due to water pressure changes, sprinkler efficiency, and environmental factors.
                </p>
                <p>
                    <strong>Q4: Can I use this for drip irrigation systems?</strong><br>
                    A: Yes, but you'll need to know the flow rate per emitter and the total number of emitters instead of sprinklers.
                </p>
                <p>
                    <strong>Q5: How can I reduce my sprinkler water usage?</strong><br>
                    A: Consider using more efficient sprinkler heads, reducing operating time, watering during cooler parts of the day, and implementing rain sensors.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Sprinkler Usage Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
