
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sprinkler Water Usage Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Sprinkler Water Usage Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Sprinkler Water Usage Formula:
                </p>
<div class="formula-container">
    \[ \text{Water Usage} = \text{Area} \times \text{Application Rate} \times \text{Time} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.01" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="application_rate" class="label-box">Application Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="application_rate" name="application_rate" step="0.01" min="0" value="<?php echo isset($_POST['application_rate']) ? htmlspecialchars($_POST['application_rate']) : ''; ?>" required>
                                <span class="calc-input">mm/h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time" class="label-box">Time:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time" name="time" step="0.01" min="0" value="<?php echo isset($_POST['time']) ? htmlspecialchars($_POST['time']) : ''; ?>" required>
                                <span class="calc-input">h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['application_rate']) &&
                        isset($_POST['time'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $application_rate = floatval($_POST['application_rate']);
                        $time = floatval($_POST['time']);

                        if ($area > 0 && $application_rate > 0 && $time > 0) {
                            // Calculate water usage: area (m²) * application_rate (mm/h) * time (h)
                            // Convert mm to m: 1 mm = 0.001 m
                            // So water usage = area * (application_rate * 0.001) * time
                            $water_usage = $area * ($application_rate * 0.001) * $time;
                            // Convert to liters: 1 m³ = 1000 L
                            $water_usage_liters = $water_usage * 1000;
                            $water_usage_liters = round($water_usage_liters, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water_usage_liters) ? htmlspecialchars($water_usage_liters) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Sprinkler Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Sprinkler Water Usage Calculation?</h3>
                <p>
The sprinkler water usage calculation estimates the total volume of water used by a sprinkler system based on the area covered, application rate of the sprinkler, and the duration of operation. This helps in water conservation and irrigation planning.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Water Usage} = \text{Area} \times \text{Application Rate} \times \text{Time} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Area} \) — Area covered by the sprinkler in square meters (m²)</li>
                        <li>\( \text{Application Rate} \) — Rate at which water is applied in millimeters per hour (mm/h)</li>
                        <li>\( \text{Time} \) — Duration of sprinkler operation in hours (h)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the volume of water used by multiplying the area by the depth of water applied (converted from mm to m) and the time.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for efficient irrigation, water conservation, cost management, and ensuring adequate water supply for landscapes and crops.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the area in square meters, application rate in millimeters per hour, and time in hours. All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why calculate sprinkler water usage?</strong><br>
                    A: It helps in planning irrigation schedules, conserving water, reducing costs, and preventing over-watering or under-watering.
                </p>
                <p>
                    <strong>Q2: How do I measure the application rate?</strong><br>
                    A: The application rate is typically provided by the sprinkler manufacturer. It can also be measured using catch cans placed in the sprinkler's coverage area.
                </p>
                <p>
                    <strong>Q3: What is a typical application rate for sprinklers?</strong><br>
                    A: Application rates vary by sprinkler type but generally range from 5 mm/h to 25 mm/h for residential sprinklers.
                </p>
                <p>
                    <strong>Q4: Can I use this for drip irrigation?</strong><br>
                    A: This calculator is designed for sprinkler systems. Drip irrigation calculations may require different parameters like emitter flow rate and spacing.
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: The accuracy depends on the precision of the input values. For best results, use measured values for area, application rate, and time.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Sprinkler Water Usage Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>