
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sprinkler Water Use Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Sprinkler Water Use Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Sprinkler Water Use Formula:
                </p>
<div class="formula-container">
    \[ \text{use} = \text{area\_sprink} \times \text{rate\_sprink} \times \text{time\_sprink} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area_sprink" class="label-box">Sprinkler Area (area_sprink):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area_sprink" name="area_sprink" step="0.0001" min="0" value="<?php echo isset($_POST['area_sprink']) ? htmlspecialchars($_POST['area_sprink']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rate_sprink" class="label-box">Sprinkler Rate (rate_sprink):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rate_sprink" name="rate_sprink" step="0.0001" min="0" value="<?php echo isset($_POST['rate_sprink']) ? htmlspecialchars($_POST['rate_sprink']) : ''; ?>" required>
                                <span class="calc-input">mm/h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time_sprink" class="label-box">Sprinkler Time (time_sprink):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time_sprink" name="time_sprink" step="0.0001" min="0" value="<?php echo isset($_POST['time_sprink']) ? htmlspecialchars($_POST['time_sprink']) : ''; ?>" required>
                                <span class="calc-input">h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area_sprink']) && 
                        isset($_POST['rate_sprink']) &&
                        isset($_POST['time_sprink'])) {
                        
                        // Get input values
                        $area_sprink = floatval($_POST['area_sprink']);
                        $rate_sprink = floatval($_POST['rate_sprink']);
                        $time_sprink = floatval($_POST['time_sprink']);

                        if ($area_sprink > 0 && $rate_sprink > 0 && $time_sprink > 0) {
                            // Calculate sprinkler water use
                            $use = $area_sprink * $rate_sprink * $time_sprink;
                            $use = round($use, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Use (use):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($use) ? htmlspecialchars($use) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Sprinkler Water Use Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Use Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Sprinkler Water Use Formula?</h3>
                <p>
The Sprinkler Water Use formula calculates the total water consumption of a sprinkler system based on the area covered, application rate, and operating time. This helps in efficient water management for irrigation purposes.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Sprinkler Water Use formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{use} = \text{area\_sprink} \times \text{rate\_sprink} \times \text{time\_sprink} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{area\_sprink} \) — Area covered by sprinkler (m²)</li>
                        <li>\( \text{rate\_sprink} \) — Application rate of sprinkler (mm/h)</li>
                        <li>\( \text{time\_sprink} \) — Operating time of sprinkler (h)</li>
                        <li>\( \text{use} \) — Total water use (L)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula multiplies the area, application rate, and time to determine the total volume of water used by the sprinkler system.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Use Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water use calculation is essential for efficient irrigation planning, water conservation, cost management, and ensuring proper hydration for plants without wastage.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the area in square meters, application rate in mm per hour, and operating time in hours. All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why calculate sprinkler water use?</strong><br>
                    A: Calculating water use helps in efficient irrigation planning, reduces water waste, and ensures plants receive adequate hydration.
                </p>
                <p>
                    <strong>Q2: What is a typical application rate for sprinklers?</strong><br>
                    A: Application rates vary by sprinkler type but typically range from 5-25 mm/h depending on the system and nozzle design.
                </p>
                <p>
                    <strong>Q3: How can I reduce sprinkler water use?</strong><br>
                    A: Use water-efficient nozzles, water during cooler times of day, adjust run times based on weather conditions, and regularly maintain your irrigation system.
                </p>
                <p>
                    <strong>Q4: Does this calculation account for evaporation loss?</strong><br>
                    A: No, this is a basic calculation that doesn't factor in evaporation. For more precise calculations, evaporation rates should be considered separately.
                </p>
                <p>
                    <strong>Q5: Can I use this for different area units?</strong><br>
                    A: The calculator uses square meters. If you have measurements in other units, convert them to square meters first for accurate results.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Sprinkler Water Use Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
