
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>State Water Heater Sizing Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>State Water Heater Sizing Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    State Water Heater Sizing Formula:
                </p>
<div class="formula-container">
    \[ \text{Capacity (gal)} = \text{Peak demand (gph)} \times \text{Duration (h)} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="peak_demand" class="label-box">Peak Demand:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="peak_demand" name="peak_demand" step="0.01" min="0" value="<?php echo isset($_POST['peak_demand']) ? htmlspecialchars($_POST['peak_demand']) : ''; ?>" required>
                                <span class="calc-input">gallons per hour</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="duration" class="label-box">Duration:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="duration" name="duration" step="0.01" min="0" value="<?php echo isset($_POST['duration']) ? htmlspecialchars($_POST['duration']) : ''; ?>" required>
                                <span class="calc-input">hours</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['peak_demand']) && 
                        isset($_POST['duration'])) {
                        
                        // Get input values
                        $peak_demand = floatval($_POST['peak_demand']);
                        $duration = floatval($_POST['duration']);

                        if ($peak_demand > 0 && $duration > 0) {
                            // Calculate water heater capacity
                            $capacity = $peak_demand * $duration;
                            $capacity = round($capacity, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Capacity:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($capacity) ? htmlspecialchars($capacity) . " gallons" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is State Water Heater Sizing?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Water Heater Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is State Water Heater Sizing?</h3>
                <p>
State water heater sizing calculates the appropriate capacity of a water heater based on peak demand and duration of use. Proper sizing ensures adequate hot water supply while optimizing energy efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Capacity (gal)} = \text{Peak demand (gph)} \times \text{Duration (h)} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>Peak demand — Maximum gallons of hot water needed per hour</li>
                        <li>Duration — Hours of peak hot water usage</li>
                        <li>Capacity — Required water heater size in gallons</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the minimum water heater capacity needed to meet peak hot water demand over a specific duration.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Water Heater Sizing</h3>
                <p>
                    <strong>Details:</strong> Correct water heater sizing is essential for ensuring adequate hot water supply, improving energy efficiency, reducing operating costs, and extending equipment lifespan.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter peak hot water demand in gallons per hour and the expected duration of peak usage in hours. Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors affect peak hot water demand?</strong><br>
                    A: Number of occupants, simultaneous appliance use, shower flow rates, and lifestyle habits all influence peak demand.
                </p>
                <p>
                    <strong>Q2: How do I estimate my peak hot water demand?</strong><br>
                    A: Calculate the total flow rate of all hot water fixtures that might be used simultaneously during peak periods.
                </p>
                <p>
                    <strong>Q3: What's a typical duration for peak usage?</strong><br>
                    A: Peak usage typically lasts 1-2 hours during morning or evening routines when multiple people use hot water simultaneously.
                </p>
                <p>
                    <strong>Q4: Should I add a safety margin to the calculated capacity?</strong><br>
                    A: Yes, it's recommended to add 10-20% to the calculated capacity to account for variations in usage patterns.
                </p>
                <p>
                    <strong>Q5: Does this calculation work for all water heater types?</strong><br>
                    A: This formula is primarily for storage tank water heaters. Tankless and heat pump water heaters require different sizing calculations.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                State Water Heater Sizing Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
